/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.WebhookEndpoint;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableWebhookEndpoint
implements WebhookEndpoint {
    private final String url;

    private ImmutableWebhookEndpoint(String url) {
        this.url = url;
    }

    @Override
    public String url() {
        return this.url;
    }

    public final ImmutableWebhookEndpoint withUrl(String value) {
        if (this.url.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"url");
        return new ImmutableWebhookEndpoint(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookEndpoint && this.equalTo((ImmutableWebhookEndpoint)another);
    }

    private boolean equalTo(ImmutableWebhookEndpoint another) {
        return this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WebhookEndpoint").omitNullValues().add("url", (Object)this.url).toString();
    }

    public static ImmutableWebhookEndpoint copyOf(WebhookEndpoint instance) {
        if (instance instanceof ImmutableWebhookEndpoint) {
            return (ImmutableWebhookEndpoint)instance;
        }
        return ImmutableWebhookEndpoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private long initBits = 1L;
        @Nullable
        private String url;

        private Builder() {
        }

        public final Builder from(WebhookEndpoint instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.url(instance.url());
            return this;
        }

        public final Builder url(String url) {
            this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableWebhookEndpoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookEndpoint(this.url);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build WebhookEndpoint, some of required attributes are not set " + attributes;
        }
    }
}

