/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.WebhookResponse;
import org.wisepersist.pinpayments.pojo.WebhookResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableWebhookResponse
implements WebhookResponse {
    private final WebhookResult response;

    private ImmutableWebhookResponse(WebhookResult response) {
        this.response = response;
    }

    @Override
    public WebhookResult response() {
        return this.response;
    }

    public final ImmutableWebhookResponse withResponse(WebhookResult value) {
        if (this.response == value) {
            return this;
        }
        WebhookResult newValue = (WebhookResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableWebhookResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookResponse && this.equalTo((ImmutableWebhookResponse)another);
    }

    private boolean equalTo(ImmutableWebhookResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WebhookResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableWebhookResponse copyOf(WebhookResponse instance) {
        if (instance instanceof ImmutableWebhookResponse) {
            return (ImmutableWebhookResponse)instance;
        }
        return ImmutableWebhookResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private WebhookResult response;

        private Builder() {
        }

        public final Builder from(WebhookResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(WebhookResult response) {
            this.response = (WebhookResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableWebhookResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build WebhookResponse, some of required attributes are not set " + attributes;
        }
    }
}

