/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.apuava.http.HttpStatus;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.CardTokensApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCardResponse;
import org.wisepersist.pinpayments.pojo.ImmutableErrorResponse;

public class CardTokensApiImpl
extends AbstractBaseApi
implements CardTokensApi {
    private static final Logger log = LoggerFactory.getLogger(CardTokensApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final CardResponse create(Card card) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(card);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getCardResponse(httpResponse);
    }

    protected final CardResponse getCardResponse(HttpResponse httpResponse) {
        CardResponse result;
        if (httpResponse.getStatusCode() == HttpStatus.CREATED.getCode()) {
            result = (CardResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCardResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableCardResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }

    @Override
    protected final String getApiName() {
        return "cards";
    }
}

