/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.CustomersApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.CardListResponse;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.ChargeListResponse;
import org.wisepersist.pinpayments.pojo.Customer;
import org.wisepersist.pinpayments.pojo.CustomerListResponse;
import org.wisepersist.pinpayments.pojo.CustomerResponse;
import org.wisepersist.pinpayments.pojo.DeletionResult;
import org.wisepersist.pinpayments.pojo.ImmutableCardListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCardResponse;
import org.wisepersist.pinpayments.pojo.ImmutableChargeListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCustomerListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCustomerResponse;

public class CustomersApiImpl
extends AbstractBaseApi
implements CustomersApi {
    private static final Logger log = LoggerFactory.getLogger(CustomersApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final CustomerResponse create(Customer customer) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(customer);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (CustomerResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCustomerResponse.class);
    }

    @Override
    public final CustomerListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableCustomerListResponse.class);
    }

    @Override
    public final CustomerResponse fetch(String customerToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (CustomerResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCustomerResponse.class);
    }

    @Override
    public final CustomerResponse update(String customerToken, Customer customer) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(customer);
        String url = String.format("%s/%s", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForPut().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (CustomerResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCustomerResponse.class);
    }

    @Override
    public final DeletionResult delete(String customerToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForDelete().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getDeletionResult(httpResponse);
    }

    @Override
    public final ChargeListResponse listCharges(String customerToken, int page) throws IOException {
        String url = String.format("%s/%s/charges", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (ChargeListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableChargeListResponse.class);
    }

    @Override
    public final CardListResponse listCards(String customerToken, int page) throws IOException {
        String url = String.format("%s/%s/cards", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (CardListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCardListResponse.class);
    }

    @Override
    public final CardResponse createCard(String customerToken, Card card) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(card);
        String url = String.format("%s/%s/cards", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (CardResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCardResponse.class);
    }

    @Override
    public final DeletionResult deleteCard(String customerToken, String cardToken) throws IOException {
        String url = String.format("%s/%s/cards/%s", this.getApiUrl(), customerToken, cardToken);
        HttpResponse httpResponse = this.httpTransportForDelete().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getDeletionResult(httpResponse);
    }

    @Override
    protected final String getApiName() {
        return "customers";
    }
}

