/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.WebhookEndpointsApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.DeletionResult;
import org.wisepersist.pinpayments.pojo.ImmutableWebhookEndpointListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableWebhookEndpointResponse;
import org.wisepersist.pinpayments.pojo.WebhookEndpoint;
import org.wisepersist.pinpayments.pojo.WebhookEndpointListResponse;
import org.wisepersist.pinpayments.pojo.WebhookEndpointResponse;

public class WebhookEndpointsApiImpl
extends AbstractBaseApi
implements WebhookEndpointsApi {
    private static final Logger log = LoggerFactory.getLogger(WebhookEndpointsApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final WebhookEndpointResponse create(WebhookEndpoint endpoint) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(endpoint);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (WebhookEndpointResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableWebhookEndpointResponse.class);
    }

    @Override
    public final WebhookEndpointListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableWebhookEndpointListResponse.class);
    }

    @Override
    public final WebhookEndpointResponse fetch(String endpointToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), endpointToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (WebhookEndpointResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableWebhookEndpointResponse.class);
    }

    @Override
    public final DeletionResult delete(String endpointToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), endpointToken);
        HttpResponse httpResponse = this.httpTransportForDelete().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getDeletionResult(httpResponse);
    }

    @Override
    protected final String getApiName() {
        return "webhook_endpoints";
    }
}

