/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.ImmutableCard;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCard
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CardTypeAdapter.adapts(type)) {
            return new CardTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCard(Card)";
    }

    private static class CardTypeAdapter
    extends TypeAdapter<Card> {
        CardTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return Card.class == type.getRawType() || ImmutableCard.class == type.getRawType();
        }

        public void write(JsonWriter out, Card value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCard(out, value);
            }
        }

        public Card read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCard(in);
        }

        private void writeCard(JsonWriter out, Card instance) throws IOException {
            out.beginObject();
            out.name("number");
            out.value(instance.number());
            out.name("cvc");
            out.value(instance.cvc());
            out.name("expiry_month");
            out.value(instance.expiryMonth());
            out.name("expiry_year");
            out.value(instance.expiryYear());
            out.name("name");
            out.value(instance.name());
            out.name("address_line1");
            out.value(instance.addressLine1());
            String addressLine2Value = instance.addressLine2();
            if (addressLine2Value != null) {
                out.name("address_line2");
                out.value(addressLine2Value);
            } else if (out.getSerializeNulls()) {
                out.name("address_line2");
                out.nullValue();
            }
            out.name("address_city");
            out.value(instance.addressCity());
            String addressPostcodeValue = instance.addressPostcode();
            if (addressPostcodeValue != null) {
                out.name("address_postcode");
                out.value(addressPostcodeValue);
            } else if (out.getSerializeNulls()) {
                out.name("address_postcode");
                out.nullValue();
            }
            String addressStateValue = instance.addressState();
            if (addressStateValue != null) {
                out.name("address_state");
                out.value(addressStateValue);
            } else if (out.getSerializeNulls()) {
                out.name("address_state");
                out.nullValue();
            }
            out.name("address_country");
            out.value(instance.addressCountry());
            out.endObject();
        }

        private Card readCard(JsonReader in) throws IOException {
            ImmutableCard.Builder builder = ImmutableCard.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'n': {
                    if ("number".equals(attributeName)) {
                        this.readInNumber(in, builder);
                        return;
                    }
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
                case 'c': {
                    if (!"cvc".equals(attributeName)) break;
                    this.readInCvc(in, builder);
                    return;
                }
                case 'e': {
                    if ("expiry_month".equals(attributeName)) {
                        this.readInExpiryMonth(in, builder);
                        return;
                    }
                    if (!"expiry_year".equals(attributeName)) break;
                    this.readInExpiryYear(in, builder);
                    return;
                }
                case 'a': {
                    if ("address_line1".equals(attributeName)) {
                        this.readInAddressLine1(in, builder);
                        return;
                    }
                    if ("address_line2".equals(attributeName)) {
                        this.readInAddressLine2(in, builder);
                        return;
                    }
                    if ("address_city".equals(attributeName)) {
                        this.readInAddressCity(in, builder);
                        return;
                    }
                    if ("address_postcode".equals(attributeName)) {
                        this.readInAddressPostcode(in, builder);
                        return;
                    }
                    if ("address_state".equals(attributeName)) {
                        this.readInAddressState(in, builder);
                        return;
                    }
                    if (!"address_country".equals(attributeName)) break;
                    this.readInAddressCountry(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInNumber(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.number(in.nextString());
        }

        private void readInCvc(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.cvc(in.nextString());
        }

        private void readInExpiryMonth(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.expiryMonth(in.nextString());
        }

        private void readInExpiryYear(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.expiryYear(in.nextString());
        }

        private void readInName(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.name(in.nextString());
        }

        private void readInAddressLine1(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.addressLine1(in.nextString());
        }

        private void readInAddressLine2(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addressLine2(in.nextString());
            }
        }

        private void readInAddressCity(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.addressCity(in.nextString());
        }

        private void readInAddressPostcode(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addressPostcode(in.nextString());
            }
        }

        private void readInAddressState(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addressState(in.nextString());
            }
        }

        private void readInAddressCountry(JsonReader in, ImmutableCard.Builder builder) throws IOException {
            builder.addressCountry(in.nextString());
        }
    }
}

