/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.Customer;
import org.wisepersist.pinpayments.pojo.ImmutableCustomer;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCustomer
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CustomerTypeAdapter.adapts(type)) {
            return new CustomerTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCustomer(Customer)";
    }

    private static class CustomerTypeAdapter
    extends TypeAdapter<Customer> {
        public final Card cardTypeSample = null;
        private final TypeAdapter<Card> cardTypeAdapter;

        CustomerTypeAdapter(Gson gson) {
            this.cardTypeAdapter = gson.getAdapter(Card.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Customer.class == type.getRawType() || ImmutableCustomer.class == type.getRawType();
        }

        public void write(JsonWriter out, Customer value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCustomer(out, value);
            }
        }

        public Customer read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCustomer(in);
        }

        private void writeCustomer(JsonWriter out, Customer instance) throws IOException {
            out.beginObject();
            Card cardValue = instance.card();
            if (cardValue != null) {
                out.name("card");
                this.cardTypeAdapter.write(out, (Object)cardValue);
            } else if (out.getSerializeNulls()) {
                out.name("card");
                out.nullValue();
            }
            String cardTokenValue = instance.cardToken();
            if (cardTokenValue != null) {
                out.name("card_token");
                out.value(cardTokenValue);
            } else if (out.getSerializeNulls()) {
                out.name("card_token");
                out.nullValue();
            }
            out.name("email");
            out.value(instance.email());
            out.endObject();
        }

        private Customer readCustomer(JsonReader in) throws IOException {
            ImmutableCustomer.Builder builder = ImmutableCustomer.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCustomer.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'c': {
                    if ("card".equals(attributeName)) {
                        this.readInCard(in, builder);
                        return;
                    }
                    if (!"card_token".equals(attributeName)) break;
                    this.readInCardToken(in, builder);
                    return;
                }
                case 'e': {
                    if (!"email".equals(attributeName)) break;
                    this.readInEmail(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInCard(JsonReader in, ImmutableCustomer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Card value = (Card)this.cardTypeAdapter.read(in);
                builder.card(value);
            }
        }

        private void readInCardToken(JsonReader in, ImmutableCustomer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.cardToken(in.nextString());
            }
        }

        private void readInEmail(JsonReader in, ImmutableCustomer.Builder builder) throws IOException {
            builder.email(in.nextString());
        }
    }
}

