/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.EventResult;
import org.wisepersist.pinpayments.pojo.ImmutableEventResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersEventResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (EventResultTypeAdapter.adapts(type)) {
            return new EventResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersEventResult(EventResult)";
    }

    private static class EventResultTypeAdapter
    extends TypeAdapter<EventResult> {
        public final HashMap<String, Object> dataTypeSample = null;
        private final TypeAdapter<HashMap<String, Object>> dataTypeAdapter;

        EventResultTypeAdapter(Gson gson) {
            this.dataTypeAdapter = gson.getAdapter(TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{String.class, Object.class}));
        }

        static boolean adapts(TypeToken<?> type) {
            return EventResult.class == type.getRawType() || ImmutableEventResult.class == type.getRawType();
        }

        public void write(JsonWriter out, EventResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeEventResult(out, value);
            }
        }

        public EventResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readEventResult(in);
        }

        private void writeEventResult(JsonWriter out, EventResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            out.name("type");
            out.value(instance.type());
            out.name("data");
            this.dataTypeAdapter.write(out, instance.data());
            out.name("created_at");
            out.value(instance.createdAt());
            out.endObject();
        }

        private EventResult readEventResult(JsonReader in) throws IOException {
            ImmutableEventResult.Builder builder = ImmutableEventResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableEventResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if ("token".equals(attributeName)) {
                        this.readInToken(in, builder);
                        return;
                    }
                    if (!"type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 'd': {
                    if (!"data".equals(attributeName)) break;
                    this.readInData(in, builder);
                    return;
                }
                case 'c': {
                    if (!"created_at".equals(attributeName)) break;
                    this.readInCreatedAt(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableEventResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInType(JsonReader in, ImmutableEventResult.Builder builder) throws IOException {
            builder.type(in.nextString());
        }

        private void readInData(JsonReader in, ImmutableEventResult.Builder builder) throws IOException {
            HashMap value = (HashMap)this.dataTypeAdapter.read(in);
            builder.data(value);
        }

        private void readInCreatedAt(JsonReader in, ImmutableEventResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }
    }
}

