/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutablePagination;
import org.wisepersist.pinpayments.pojo.Pagination;

@ParametersAreNonnullByDefault
public final class GsonAdaptersPagination
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (PaginationTypeAdapter.adapts(type)) {
            return new PaginationTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersPagination(Pagination)";
    }

    private static class PaginationTypeAdapter
    extends TypeAdapter<Pagination> {
        PaginationTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return Pagination.class == type.getRawType() || ImmutablePagination.class == type.getRawType();
        }

        public void write(JsonWriter out, Pagination value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writePagination(out, value);
            }
        }

        public Pagination read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readPagination(in);
        }

        private void writePagination(JsonWriter out, Pagination instance) throws IOException {
            out.beginObject();
            out.name("current");
            out.value((long)instance.current());
            out.name("per_page");
            out.value((long)instance.perPage());
            out.name("count");
            out.value((long)instance.count());
            out.endObject();
        }

        private Pagination readPagination(JsonReader in) throws IOException {
            ImmutablePagination.Builder builder = ImmutablePagination.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutablePagination.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'c': {
                    if ("current".equals(attributeName)) {
                        this.readInCurrent(in, builder);
                        return;
                    }
                    if (!"count".equals(attributeName)) break;
                    this.readInCount(in, builder);
                    return;
                }
                case 'p': {
                    if (!"per_page".equals(attributeName)) break;
                    this.readInPerPage(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInCurrent(JsonReader in, ImmutablePagination.Builder builder) throws IOException {
            builder.current(in.nextInt());
        }

        private void readInPerPage(JsonReader in, ImmutablePagination.Builder builder) throws IOException {
            builder.perPage(in.nextInt());
        }

        private void readInCount(JsonReader in, ImmutablePagination.Builder builder) throws IOException {
            builder.count(in.nextInt());
        }
    }
}

