/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableTransferListResponse;
import org.wisepersist.pinpayments.pojo.Pagination;
import org.wisepersist.pinpayments.pojo.TransferListResponse;
import org.wisepersist.pinpayments.pojo.TransferResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersTransferListResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (TransferListResponseTypeAdapter.adapts(type)) {
            return new TransferListResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersTransferListResponse(TransferListResponse)";
    }

    private static class TransferListResponseTypeAdapter
    extends TypeAdapter<TransferListResponse> {
        public final TransferResult responseTypeSample = null;
        public final Pagination paginationTypeSample = null;
        private final TypeAdapter<TransferResult> responseTypeAdapter;
        private final TypeAdapter<Pagination> paginationTypeAdapter;

        TransferListResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(TransferResult.class);
            this.paginationTypeAdapter = gson.getAdapter(Pagination.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return TransferListResponse.class == type.getRawType() || ImmutableTransferListResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, TransferListResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeTransferListResponse(out, value);
            }
        }

        public TransferListResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readTransferListResponse(in);
        }

        private void writeTransferListResponse(JsonWriter out, TransferListResponse instance) throws IOException {
            out.beginObject();
            List<TransferResult> responseElements = instance.response();
            out.name("response");
            out.beginArray();
            for (TransferResult e : responseElements) {
                this.responseTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("pagination");
            this.paginationTypeAdapter.write(out, (Object)instance.pagination());
            out.endObject();
        }

        private TransferListResponse readTransferListResponse(JsonReader in) throws IOException {
            ImmutableTransferListResponse.Builder builder = ImmutableTransferListResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableTransferListResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pagination".equals(attributeName)) break;
                    this.readInPagination(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableTransferListResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    TransferResult value = (TransferResult)this.responseTypeAdapter.read(in);
                    builder.addResponse(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                TransferResult value = (TransferResult)this.responseTypeAdapter.read(in);
                builder.addResponse(value);
            }
        }

        private void readInPagination(JsonReader in, ImmutableTransferListResponse.Builder builder) throws IOException {
            Pagination value = (Pagination)this.paginationTypeAdapter.read(in);
            builder.pagination(value);
        }
    }
}

