/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.BankAccountResult;
import org.wisepersist.pinpayments.pojo.RecipientBase;
import org.wisepersist.pinpayments.pojo.RecipientResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRecipientResult
implements RecipientResult {
    private final String token;
    private final String createdAt;
    @Nullable
    private final BankAccountResult bankAccount;
    private final String email;
    @Nullable
    private final String name;

    private ImmutableRecipientResult(String token, String createdAt, @Nullable BankAccountResult bankAccount, String email, @Nullable String name) {
        this.token = token;
        this.createdAt = createdAt;
        this.bankAccount = bankAccount;
        this.email = email;
        this.name = name;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    @Nullable
    public BankAccountResult bankAccount() {
        return this.bankAccount;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    public final ImmutableRecipientResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableRecipientResult(newValue, this.createdAt, this.bankAccount, this.email, this.name);
    }

    public final ImmutableRecipientResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableRecipientResult(this.token, newValue, this.bankAccount, this.email, this.name);
    }

    public final ImmutableRecipientResult withBankAccount(@Nullable BankAccountResult value) {
        if (this.bankAccount == value) {
            return this;
        }
        return new ImmutableRecipientResult(this.token, this.createdAt, value, this.email, this.name);
    }

    public final ImmutableRecipientResult withEmail(String value) {
        if (this.email.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"email");
        return new ImmutableRecipientResult(this.token, this.createdAt, this.bankAccount, newValue, this.name);
    }

    public final ImmutableRecipientResult withName(@Nullable String value) {
        if (Objects.equal((Object)this.name, (Object)value)) {
            return this;
        }
        return new ImmutableRecipientResult(this.token, this.createdAt, this.bankAccount, this.email, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecipientResult && this.equalTo((ImmutableRecipientResult)another);
    }

    private boolean equalTo(ImmutableRecipientResult another) {
        return this.token.equals(another.token) && this.createdAt.equals(another.createdAt) && Objects.equal((Object)this.bankAccount, (Object)another.bankAccount) && this.email.equals(another.email) && Objects.equal((Object)this.name, (Object)another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.bankAccount});
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.name});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RecipientResult").omitNullValues().add("token", (Object)this.token).add("createdAt", (Object)this.createdAt).add("bankAccount", (Object)this.bankAccount).add("email", (Object)this.email).add("name", (Object)this.name).toString();
    }

    public static ImmutableRecipientResult copyOf(RecipientResult instance) {
        if (instance instanceof ImmutableRecipientResult) {
            return (ImmutableRecipientResult)instance;
        }
        return ImmutableRecipientResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_CREATED_AT = 2L;
        private static final long INIT_BIT_EMAIL = 4L;
        private long initBits = 7L;
        @Nullable
        private String token;
        @Nullable
        private String createdAt;
        @Nullable
        private BankAccountResult bankAccount;
        @Nullable
        private String email;
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(RecipientResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecipientBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RecipientBase instance;
            if (object instanceof RecipientResult) {
                instance = (RecipientResult)object;
                BankAccountResult bankAccountValue = instance.bankAccount();
                if (bankAccountValue != null) {
                    this.bankAccount(bankAccountValue);
                }
                this.createdAt(instance.createdAt());
                this.token(instance.token());
            }
            if (object instanceof RecipientBase) {
                instance = (RecipientBase)object;
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                this.email(instance.email());
            }
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bankAccount(@Nullable BankAccountResult bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public final Builder email(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public ImmutableRecipientResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecipientResult(this.token, this.createdAt, this.bankAccount, this.email, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build RecipientResult, some of required attributes are not set " + attributes;
        }
    }
}

