/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.RefundResponse;
import org.wisepersist.pinpayments.pojo.RefundResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRefundResponse
implements RefundResponse {
    private final RefundResult response;

    private ImmutableRefundResponse(RefundResult response) {
        this.response = response;
    }

    @Override
    public RefundResult response() {
        return this.response;
    }

    public final ImmutableRefundResponse withResponse(RefundResult value) {
        if (this.response == value) {
            return this;
        }
        RefundResult newValue = (RefundResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableRefundResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefundResponse && this.equalTo((ImmutableRefundResponse)another);
    }

    private boolean equalTo(ImmutableRefundResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RefundResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableRefundResponse copyOf(RefundResponse instance) {
        if (instance instanceof ImmutableRefundResponse) {
            return (ImmutableRefundResponse)instance;
        }
        return ImmutableRefundResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private RefundResult response;

        private Builder() {
        }

        public final Builder from(RefundResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(RefundResult response) {
            this.response = (RefundResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRefundResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefundResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build RefundResponse, some of required attributes are not set " + attributes;
        }
    }
}

