/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.RefundResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRefundResult
implements RefundResult {
    private final String token;
    @Nullable
    private final Boolean success;
    private final Integer amount;
    private final String currency;
    private final String charge;
    private final String createdAt;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String statusMessage;

    private ImmutableRefundResult(String token, @Nullable Boolean success, Integer amount, String currency, String charge, String createdAt, @Nullable String errorMessage, @Nullable String statusMessage) {
        this.token = token;
        this.success = success;
        this.amount = amount;
        this.currency = currency;
        this.charge = charge;
        this.createdAt = createdAt;
        this.errorMessage = errorMessage;
        this.statusMessage = statusMessage;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    @Nullable
    public Boolean success() {
        return this.success;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public String charge() {
        return this.charge;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    @Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    @Nullable
    public String statusMessage() {
        return this.statusMessage;
    }

    public final ImmutableRefundResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableRefundResult(newValue, this.success, this.amount, this.currency, this.charge, this.createdAt, this.errorMessage, this.statusMessage);
    }

    public final ImmutableRefundResult withSuccess(@Nullable Boolean value) {
        if (Objects.equal((Object)this.success, (Object)value)) {
            return this;
        }
        return new ImmutableRefundResult(this.token, value, this.amount, this.currency, this.charge, this.createdAt, this.errorMessage, this.statusMessage);
    }

    public final ImmutableRefundResult withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableRefundResult(this.token, this.success, newValue, this.currency, this.charge, this.createdAt, this.errorMessage, this.statusMessage);
    }

    public final ImmutableRefundResult withCurrency(String value) {
        if (this.currency.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"currency");
        return new ImmutableRefundResult(this.token, this.success, this.amount, newValue, this.charge, this.createdAt, this.errorMessage, this.statusMessage);
    }

    public final ImmutableRefundResult withCharge(String value) {
        if (this.charge.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"charge");
        return new ImmutableRefundResult(this.token, this.success, this.amount, this.currency, newValue, this.createdAt, this.errorMessage, this.statusMessage);
    }

    public final ImmutableRefundResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableRefundResult(this.token, this.success, this.amount, this.currency, this.charge, newValue, this.errorMessage, this.statusMessage);
    }

    public final ImmutableRefundResult withErrorMessage(@Nullable String value) {
        if (Objects.equal((Object)this.errorMessage, (Object)value)) {
            return this;
        }
        return new ImmutableRefundResult(this.token, this.success, this.amount, this.currency, this.charge, this.createdAt, value, this.statusMessage);
    }

    public final ImmutableRefundResult withStatusMessage(@Nullable String value) {
        if (Objects.equal((Object)this.statusMessage, (Object)value)) {
            return this;
        }
        return new ImmutableRefundResult(this.token, this.success, this.amount, this.currency, this.charge, this.createdAt, this.errorMessage, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefundResult && this.equalTo((ImmutableRefundResult)another);
    }

    private boolean equalTo(ImmutableRefundResult another) {
        return this.token.equals(another.token) && Objects.equal((Object)this.success, (Object)another.success) && this.amount.equals(another.amount) && this.currency.equals(another.currency) && this.charge.equals(another.charge) && this.createdAt.equals(another.createdAt) && Objects.equal((Object)this.errorMessage, (Object)another.errorMessage) && Objects.equal((Object)this.statusMessage, (Object)another.statusMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.success});
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.charge.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorMessage});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.statusMessage});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RefundResult").omitNullValues().add("token", (Object)this.token).add("success", (Object)this.success).add("amount", (Object)this.amount).add("currency", (Object)this.currency).add("charge", (Object)this.charge).add("createdAt", (Object)this.createdAt).add("errorMessage", (Object)this.errorMessage).add("statusMessage", (Object)this.statusMessage).toString();
    }

    public static ImmutableRefundResult copyOf(RefundResult instance) {
        if (instance instanceof ImmutableRefundResult) {
            return (ImmutableRefundResult)instance;
        }
        return ImmutableRefundResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private static final long INIT_BIT_CURRENCY = 4L;
        private static final long INIT_BIT_CHARGE = 8L;
        private static final long INIT_BIT_CREATED_AT = 16L;
        private long initBits = 31L;
        @Nullable
        private String token;
        @Nullable
        private Boolean success;
        @Nullable
        private Integer amount;
        @Nullable
        private String currency;
        @Nullable
        private String charge;
        @Nullable
        private String createdAt;
        @Nullable
        private String errorMessage;
        @Nullable
        private String statusMessage;

        private Builder() {
        }

        public final Builder from(RefundResult instance) {
            String statusMessageValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.token(instance.token());
            Boolean successValue = instance.success();
            if (successValue != null) {
                this.success(successValue);
            }
            this.amount(instance.amount());
            this.currency(instance.currency());
            this.charge(instance.charge());
            this.createdAt(instance.createdAt());
            String errorMessageValue = instance.errorMessage();
            if (errorMessageValue != null) {
                this.errorMessage(errorMessageValue);
            }
            if ((statusMessageValue = instance.statusMessage()) != null) {
                this.statusMessage(statusMessageValue);
            }
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder success(@Nullable Boolean success) {
            this.success = success;
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder charge(String charge) {
            this.charge = (String)Preconditions.checkNotNull((Object)charge, (Object)"charge");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder errorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder statusMessage(@Nullable String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public ImmutableRefundResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefundResult(this.token, this.success, this.amount, this.currency, this.charge, this.createdAt, this.errorMessage, this.statusMessage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("charge");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("createdAt");
            }
            return "Cannot build RefundResult, some of required attributes are not set " + attributes;
        }
    }
}

