/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.TransferLineItem;
import org.wisepersist.pinpayments.pojo.TransferLineItemBase;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableTransferLineItem
implements TransferLineItem {
    private final String type;
    @Nullable
    private final String object;
    private final Integer amount;

    private ImmutableTransferLineItem(String type, @Nullable String object, Integer amount) {
        this.type = type;
        this.object = object;
        this.amount = amount;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public String object() {
        return this.object;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    public final ImmutableTransferLineItem withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        return new ImmutableTransferLineItem(newValue, this.object, this.amount);
    }

    public final ImmutableTransferLineItem withObject(@Nullable String value) {
        if (Objects.equal((Object)this.object, (Object)value)) {
            return this;
        }
        return new ImmutableTransferLineItem(this.type, value, this.amount);
    }

    public final ImmutableTransferLineItem withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableTransferLineItem(this.type, this.object, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransferLineItem && this.equalTo((ImmutableTransferLineItem)another);
    }

    private boolean equalTo(ImmutableTransferLineItem another) {
        return this.type.equals(another.type) && Objects.equal((Object)this.object, (Object)another.object) && this.amount.equals(another.amount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.object});
        h += (h << 5) + this.amount.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransferLineItem").omitNullValues().add("type", (Object)this.type).add("object", (Object)this.object).add("amount", (Object)this.amount).toString();
    }

    public static ImmutableTransferLineItem copyOf(TransferLineItem instance) {
        if (instance instanceof ImmutableTransferLineItem) {
            return (ImmutableTransferLineItem)instance;
        }
        return ImmutableTransferLineItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private String type;
        @Nullable
        private String object;
        @Nullable
        private Integer amount;

        private Builder() {
        }

        public final Builder from(TransferLineItemBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TransferLineItem instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof TransferLineItemBase) {
                TransferLineItemBase instance = (TransferLineItemBase)object;
                this.type(instance.type());
                this.amount(instance.amount());
                String objectValue = instance.object();
                if (objectValue != null) {
                    this.object(objectValue);
                }
            }
        }

        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder object(@Nullable String object) {
            this.object = object;
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTransferLineItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransferLineItem(this.type, this.object, this.amount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            return "Cannot build TransferLineItem, some of required attributes are not set " + attributes;
        }
    }
}

