/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.TransferResponse;
import org.wisepersist.pinpayments.pojo.TransferResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableTransferResponse
implements TransferResponse {
    private final TransferResult response;

    private ImmutableTransferResponse(TransferResult response) {
        this.response = response;
    }

    @Override
    public TransferResult response() {
        return this.response;
    }

    public final ImmutableTransferResponse withResponse(TransferResult value) {
        if (this.response == value) {
            return this;
        }
        TransferResult newValue = (TransferResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableTransferResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransferResponse && this.equalTo((ImmutableTransferResponse)another);
    }

    private boolean equalTo(ImmutableTransferResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransferResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableTransferResponse copyOf(TransferResponse instance) {
        if (instance instanceof ImmutableTransferResponse) {
            return (ImmutableTransferResponse)instance;
        }
        return ImmutableTransferResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private TransferResult response;

        private Builder() {
        }

        public final Builder from(TransferResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(TransferResult response) {
            this.response = (TransferResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTransferResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransferResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build TransferResponse, some of required attributes are not set " + attributes;
        }
    }
}

