/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.api.EventsApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.EventListResponse;
import org.wisepersist.pinpayments.pojo.EventResponse;
import org.wisepersist.pinpayments.pojo.ImmutableEventListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableEventResponse;

public class EventsApiImpl
extends AbstractBaseApi
implements EventsApi {
    private static final Logger log = LoggerFactory.getLogger(EventsApiImpl.class);
    @Inject
    private Gson gson;

    @Override
    public final EventListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableEventListResponse.class);
    }

    @Override
    public final EventResponse fetch(String eventToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), eventToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (EventResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableEventResponse.class);
    }

    @Override
    protected final String getApiName() {
        return "events";
    }
}

