/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.api.WebhooksApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.ImmutableWebhookListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableWebhookResponse;
import org.wisepersist.pinpayments.pojo.WebhookListResponse;
import org.wisepersist.pinpayments.pojo.WebhookResponse;

public class WebhooksApiImpl
extends AbstractBaseApi
implements WebhooksApi {
    private static final Logger log = LoggerFactory.getLogger(WebhooksApiImpl.class);
    @Inject
    private Gson gson;

    @Override
    public final WebhookListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableWebhookListResponse.class);
    }

    @Override
    public final WebhookResponse fetch(String webhookToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), webhookToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (WebhookResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableWebhookResponse.class);
    }

    @Override
    public final WebhookResponse replay(String webhookToken) throws IOException {
        String url = String.format("%s/%s/replay", this.getApiUrl(), webhookToken);
        HttpResponse httpResponse = this.httpTransportForPut().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (WebhookResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableWebhookResponse.class);
    }

    @Override
    protected final String getApiName() {
        return "webhooks";
    }
}

