/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.BankAccountResult;
import org.wisepersist.pinpayments.pojo.ImmutableBankAccountResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersBankAccountResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (BankAccountResultTypeAdapter.adapts(type)) {
            return new BankAccountResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersBankAccountResult(BankAccountResult)";
    }

    private static class BankAccountResultTypeAdapter
    extends TypeAdapter<BankAccountResult> {
        BankAccountResultTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return BankAccountResult.class == type.getRawType() || ImmutableBankAccountResult.class == type.getRawType();
        }

        public void write(JsonWriter out, BankAccountResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeBankAccountResult(out, value);
            }
        }

        public BankAccountResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readBankAccountResult(in);
        }

        private void writeBankAccountResult(JsonWriter out, BankAccountResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            String bankNameValue = instance.bankName();
            if (bankNameValue != null) {
                out.name("bank_name");
                out.value(bankNameValue);
            } else if (out.getSerializeNulls()) {
                out.name("bank_name");
                out.nullValue();
            }
            out.name("name");
            out.value(instance.name());
            out.name("bsb");
            out.value(instance.bsb());
            out.name("number");
            out.value(instance.number());
            out.endObject();
        }

        private BankAccountResult readBankAccountResult(JsonReader in) throws IOException {
            ImmutableBankAccountResult.Builder builder = ImmutableBankAccountResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableBankAccountResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if (!"token".equals(attributeName)) break;
                    this.readInToken(in, builder);
                    return;
                }
                case 'b': {
                    if ("bank_name".equals(attributeName)) {
                        this.readInBankName(in, builder);
                        return;
                    }
                    if (!"bsb".equals(attributeName)) break;
                    this.readInBsb(in, builder);
                    return;
                }
                case 'n': {
                    if ("name".equals(attributeName)) {
                        this.readInName(in, builder);
                        return;
                    }
                    if (!"number".equals(attributeName)) break;
                    this.readInNumber(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableBankAccountResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInBankName(JsonReader in, ImmutableBankAccountResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.bankName(in.nextString());
            }
        }

        private void readInName(JsonReader in, ImmutableBankAccountResult.Builder builder) throws IOException {
            builder.name(in.nextString());
        }

        private void readInBsb(JsonReader in, ImmutableBankAccountResult.Builder builder) throws IOException {
            builder.bsb(in.nextString());
        }

        private void readInNumber(JsonReader in, ImmutableBankAccountResult.Builder builder) throws IOException {
            builder.number(in.nextString());
        }
    }
}

