/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableRefundResult;
import org.wisepersist.pinpayments.pojo.RefundResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersRefundResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (RefundResultTypeAdapter.adapts(type)) {
            return new RefundResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRefundResult(RefundResult)";
    }

    private static class RefundResultTypeAdapter
    extends TypeAdapter<RefundResult> {
        public final Boolean successTypeSample = null;
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Boolean> successTypeAdapter;
        private final TypeAdapter<Integer> amountTypeAdapter;

        RefundResultTypeAdapter(Gson gson) {
            this.successTypeAdapter = gson.getAdapter(Boolean.class);
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RefundResult.class == type.getRawType() || ImmutableRefundResult.class == type.getRawType();
        }

        public void write(JsonWriter out, RefundResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRefundResult(out, value);
            }
        }

        public RefundResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readRefundResult(in);
        }

        private void writeRefundResult(JsonWriter out, RefundResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            Boolean successValue = instance.success();
            if (successValue != null) {
                out.name("success");
                this.successTypeAdapter.write(out, (Object)successValue);
            } else if (out.getSerializeNulls()) {
                out.name("success");
                out.nullValue();
            }
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            out.name("currency");
            out.value(instance.currency());
            out.name("charge");
            out.value(instance.charge());
            out.name("created_at");
            out.value(instance.createdAt());
            String errorMessageValue = instance.errorMessage();
            if (errorMessageValue != null) {
                out.name("errorMessage");
                out.value(errorMessageValue);
            } else if (out.getSerializeNulls()) {
                out.name("errorMessage");
                out.nullValue();
            }
            String statusMessageValue = instance.statusMessage();
            if (statusMessageValue != null) {
                out.name("statusMessage");
                out.value(statusMessageValue);
            } else if (out.getSerializeNulls()) {
                out.name("statusMessage");
                out.nullValue();
            }
            out.endObject();
        }

        private RefundResult readRefundResult(JsonReader in) throws IOException {
            ImmutableRefundResult.Builder builder = ImmutableRefundResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if (!"token".equals(attributeName)) break;
                    this.readInToken(in, builder);
                    return;
                }
                case 's': {
                    if ("success".equals(attributeName)) {
                        this.readInSuccess(in, builder);
                        return;
                    }
                    if (!"statusMessage".equals(attributeName)) break;
                    this.readInStatusMessage(in, builder);
                    return;
                }
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
                case 'c': {
                    if ("currency".equals(attributeName)) {
                        this.readInCurrency(in, builder);
                        return;
                    }
                    if ("charge".equals(attributeName)) {
                        this.readInCharge(in, builder);
                        return;
                    }
                    if (!"created_at".equals(attributeName)) break;
                    this.readInCreatedAt(in, builder);
                    return;
                }
                case 'e': {
                    if (!"errorMessage".equals(attributeName)) break;
                    this.readInErrorMessage(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInSuccess(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Boolean value = (Boolean)this.successTypeAdapter.read(in);
                builder.success(value);
            }
        }

        private void readInAmount(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }

        private void readInCurrency(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            builder.currency(in.nextString());
        }

        private void readInCharge(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            builder.charge(in.nextString());
        }

        private void readInCreatedAt(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }

        private void readInErrorMessage(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.errorMessage(in.nextString());
            }
        }

        private void readInStatusMessage(JsonReader in, ImmutableRefundResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.statusMessage(in.nextString());
            }
        }
    }
}

