/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Balance;
import org.wisepersist.pinpayments.pojo.BalanceResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableBalanceResult
implements BalanceResult {
    private final ImmutableList<Balance> available;
    private final ImmutableList<Balance> pending;

    private ImmutableBalanceResult(ImmutableList<Balance> available, ImmutableList<Balance> pending) {
        this.available = available;
        this.pending = pending;
    }

    public ImmutableList<Balance> available() {
        return this.available;
    }

    public ImmutableList<Balance> pending() {
        return this.pending;
    }

    public final ImmutableBalanceResult withAvailable(Balance ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBalanceResult((ImmutableList<Balance>)newValue, this.pending);
    }

    public final ImmutableBalanceResult withAvailable(Iterable<? extends Balance> elements) {
        if (this.available == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBalanceResult((ImmutableList<Balance>)newValue, this.pending);
    }

    public final ImmutableBalanceResult withPending(Balance ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBalanceResult(this.available, (ImmutableList<Balance>)newValue);
    }

    public final ImmutableBalanceResult withPending(Iterable<? extends Balance> elements) {
        if (this.pending == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBalanceResult(this.available, (ImmutableList<Balance>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBalanceResult && this.equalTo((ImmutableBalanceResult)another);
    }

    private boolean equalTo(ImmutableBalanceResult another) {
        return this.available.equals(another.available) && this.pending.equals(another.pending);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.available.hashCode();
        h += (h << 5) + this.pending.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BalanceResult").omitNullValues().add("available", this.available).add("pending", this.pending).toString();
    }

    public static ImmutableBalanceResult copyOf(BalanceResult instance) {
        if (instance instanceof ImmutableBalanceResult) {
            return (ImmutableBalanceResult)instance;
        }
        return ImmutableBalanceResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Balance> available = ImmutableList.builder();
        private ImmutableList.Builder<Balance> pending = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(BalanceResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllAvailable(instance.available());
            this.addAllPending(instance.pending());
            return this;
        }

        public final Builder addAvailable(Balance element) {
            this.available.add((Object)element);
            return this;
        }

        public final Builder addAvailable(Balance ... elements) {
            this.available.add((Object[])elements);
            return this;
        }

        public final Builder available(Iterable<? extends Balance> elements) {
            this.available = ImmutableList.builder();
            return this.addAllAvailable(elements);
        }

        public final Builder addAllAvailable(Iterable<? extends Balance> elements) {
            this.available.addAll(elements);
            return this;
        }

        public final Builder addPending(Balance element) {
            this.pending.add((Object)element);
            return this;
        }

        public final Builder addPending(Balance ... elements) {
            this.pending.add((Object[])elements);
            return this;
        }

        public final Builder pending(Iterable<? extends Balance> elements) {
            this.pending = ImmutableList.builder();
            return this.addAllPending(elements);
        }

        public final Builder addAllPending(Iterable<? extends Balance> elements) {
            this.pending.addAll(elements);
            return this;
        }

        public ImmutableBalanceResult build() {
            return new ImmutableBalanceResult(this.available.build(), this.pending.build());
        }
    }
}

