/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.ErrorMessage;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableErrorMessage
implements ErrorMessage {
    private final String param;
    private final String code;
    private final String message;

    private ImmutableErrorMessage(String param, String code, String message) {
        this.param = param;
        this.code = code;
        this.message = message;
    }

    @Override
    public String param() {
        return this.param;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public final ImmutableErrorMessage withParam(String value) {
        if (this.param.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"param");
        return new ImmutableErrorMessage(newValue, this.code, this.message);
    }

    public final ImmutableErrorMessage withCode(String value) {
        if (this.code.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"code");
        return new ImmutableErrorMessage(this.param, newValue, this.message);
    }

    public final ImmutableErrorMessage withMessage(String value) {
        if (this.message.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"message");
        return new ImmutableErrorMessage(this.param, this.code, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorMessage && this.equalTo((ImmutableErrorMessage)another);
    }

    private boolean equalTo(ImmutableErrorMessage another) {
        return this.param.equals(another.param) && this.code.equals(another.code) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.param.hashCode();
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorMessage").omitNullValues().add("param", (Object)this.param).add("code", (Object)this.code).add("message", (Object)this.message).toString();
    }

    public static ImmutableErrorMessage copyOf(ErrorMessage instance) {
        if (instance instanceof ImmutableErrorMessage) {
            return (ImmutableErrorMessage)instance;
        }
        return ImmutableErrorMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PARAM = 1L;
        private static final long INIT_BIT_CODE = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private long initBits = 7L;
        @Nullable
        private String param;
        @Nullable
        private String code;
        @Nullable
        private String message;

        private Builder() {
        }

        public final Builder from(ErrorMessage instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.param(instance.param());
            this.code(instance.code());
            this.message(instance.message());
            return this;
        }

        public final Builder param(String param) {
            this.param = (String)Preconditions.checkNotNull((Object)param, (Object)"param");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder code(String code) {
            this.code = (String)Preconditions.checkNotNull((Object)code, (Object)"code");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder message(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableErrorMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorMessage(this.param, this.code, this.message);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("param");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ErrorMessage, some of required attributes are not set " + attributes;
        }
    }
}

