/*
 * Copyright (c) 2017 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.pinpayments.pojo;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.gson.Gson;
import org.immutables.value.Value;

/**
 * @author delight.wjk@gmail.com
 */
@Gson.TypeAdapters
@Value.Immutable
public interface ChargeResult extends ChargeBase {

  String token();

  boolean success();

  @SerializedName("created_at")
  String createdAt();

  @SerializedName("status_message")
  String statusMessage();

  @Nullable
  @SerializedName("error_message")
  String errorMessage();

  CardResult card();

  boolean captured();

  @SerializedName("authorisation_expired")
  boolean authorisationExpired();

  List<Transfer> transfer();

  @SerializedName("amount_refunded")
  BigDecimal amountRefunded();

  @Nullable
  @SerializedName("total_fees")
  BigDecimal totalFees();

  @Nullable
  @SerializedName("merchant_entitlement")
  BigDecimal merchantEntitlement();

  @SerializedName("refund_pending")
  boolean refundPending();

  @SerializedName("settlement_currency")
  String settlementCurrency();
}
