/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;

public class ParamsHelper {
    @Inject
    private Gson gson;

    public final Map<String, String> toFlatParams(Object object) {
        Map<String, Object> paramsMap = this.toParamsMap(object);
        for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Double)) continue;
            paramsMap.put(entry.getKey(), ((Double)value).intValue());
        }
        return this.flattenParams(paramsMap);
    }

    private Map<String, Object> toParamsMap(Object object) {
        String json = this.gson.toJson(object);
        HashMap paramsMap = Maps.newHashMap();
        return (Map)this.gson.fromJson(json, paramsMap.getClass());
    }

    private Map<String, String> flattenParams(Map<String, Object> params) {
        HashMap flatParams = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap flatNestedMap = Maps.newHashMap();
                Map nestedMap = (Map)value;
                for (Map.Entry nested : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nested.getKey()), nested.getValue());
                }
                flatParams.putAll(this.flattenParams(flatNestedMap));
                continue;
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }
}

