/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpMethod;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.apuava.http.HttpStatus;
import org.wisepersist.apuava.http.HttpTransport;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.annotation.PinBaseUrl;
import org.wisepersist.pinpayments.annotation.PinSecretKey;
import org.wisepersist.pinpayments.annotation.PinVersion;
import org.wisepersist.pinpayments.pojo.CardListResponse;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.ChargeListResponse;
import org.wisepersist.pinpayments.pojo.ChargeResponse;
import org.wisepersist.pinpayments.pojo.CustomerResponse;
import org.wisepersist.pinpayments.pojo.DeletionResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCardListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCardResponse;
import org.wisepersist.pinpayments.pojo.ImmutableChargeListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableChargeResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCustomerResponse;
import org.wisepersist.pinpayments.pojo.ImmutableDeletionResult;
import org.wisepersist.pinpayments.pojo.ImmutableErrorResponse;
import org.wisepersist.pinpayments.pojo.ImmutableRefundListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableRefundResponse;
import org.wisepersist.pinpayments.pojo.RefundListResponse;
import org.wisepersist.pinpayments.pojo.RefundResponse;
import org.wisepersist.pinpayments.pojo.SearchCriteria;

public abstract class AbstractBaseApi {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseApi.class);
    @Inject
    @PinBaseUrl
    private String pinBaseUrl;
    @Inject
    @PinVersion
    private String pinVersion;
    @Inject
    @PinSecretKey
    private String pinSecretKey;
    @Inject
    private Gson gson;
    @Inject
    private ParamsHelper paramsHelper;

    protected final String getApiUrl() {
        return String.format("%s/%s", this.getApiBase(), this.getApiName());
    }

    protected final String getApiBase() {
        return String.format("%s/%s", this.pinBaseUrl, this.pinVersion);
    }

    protected abstract String getApiName();

    protected final HttpTransport httpTransportForPost() {
        return this.httpTransport().addHeader("Content-Type", "application/x-www-form-urlencoded").setHttpMethod(HttpMethod.POST);
    }

    protected final HttpTransport httpTransportForPut() {
        return this.httpTransport().addHeader("Content-Type", "application/x-www-form-urlencoded").setHttpMethod(HttpMethod.PUT);
    }

    protected final HttpTransport httpTransportForGet() {
        return this.httpTransport().setHttpMethod(HttpMethod.GET);
    }

    protected final HttpTransport httpTransportForDelete() {
        return this.httpTransport().setHttpMethod(HttpMethod.DELETE);
    }

    private HttpTransport httpTransport() {
        return new HttpTransport().addHeader("Authorization", String.format("Basic %s:", this.getEncodedSecretKey()));
    }

    private String getEncodedSecretKey() {
        return BaseEncoding.base64().encode(this.pinSecretKey.getBytes(Charsets.UTF_8));
    }

    protected final DeletionResult getDeletionResult(HttpResponse httpResponse) {
        ImmutableDeletionResult result;
        if (httpResponse.getStatusCode() == HttpStatus.NO_CONTENT.getCode()) {
            result = ImmutableDeletionResult.builder().success(true).build();
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableDeletionResult.builder().success(false).errorResponse(errorResponse).build();
        }
        return result;
    }

    protected final <T> T executeList(String url, Class<? extends T> clazz) throws IOException {
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (T)this.gson.fromJson(httpResponse.getContent(), clazz);
    }

    protected final <T> T executeSearch(String url, SearchCriteria searchCriteria, Class<? extends T> clazz) throws IOException {
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).addParams(this.paramsHelper.toFlatParams(searchCriteria)).execute();
        log.debug("httpResponse: " + httpResponse);
        return (T)this.gson.fromJson(httpResponse.getContent(), clazz);
    }

    protected final CustomerResponse getCustomerResponse(HttpStatus expectedStatus, HttpResponse httpResponse) {
        CustomerResponse result;
        if (httpResponse.getStatusCode() == expectedStatus.getCode()) {
            result = (CustomerResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCustomerResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableCustomerResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }

    protected final CardResponse getCardResponse(HttpStatus httpStatus, HttpResponse httpResponse) {
        CardResponse result;
        if (httpResponse.getStatusCode() == httpStatus.getCode()) {
            result = (CardResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCardResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableCardResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }

    protected final CardListResponse getCardListResponse(HttpStatus httpStatus, HttpResponse httpResponse) {
        CardListResponse result;
        if (httpResponse.getStatusCode() == httpStatus.getCode()) {
            result = (CardListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCardListResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableCardListResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }

    protected final ChargeResponse getChargeResponse(HttpStatus expectedStatus, HttpResponse httpResponse) {
        ChargeResponse result;
        if (httpResponse.getStatusCode() == expectedStatus.getCode()) {
            result = (ChargeResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableChargeResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableChargeResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }

    protected final ChargeListResponse getChargeListResponse(HttpResponse httpResponse) {
        ChargeListResponse result;
        if (httpResponse.getStatusCode() == HttpStatus.OK.getCode()) {
            result = (ChargeListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableChargeListResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableChargeListResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }

    protected final RefundResponse getRefundResponse(HttpStatus expectedStatus, HttpResponse httpResponse) {
        RefundResponse result;
        if (httpResponse.getStatusCode() == expectedStatus.getCode()) {
            result = (RefundResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRefundResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableRefundResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }

    protected final RefundListResponse getRefundListResponse(HttpStatus expectedStatus, HttpResponse httpResponse) {
        RefundListResponse result;
        if (httpResponse.getStatusCode() == expectedStatus.getCode()) {
            result = (RefundListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRefundListResponse.class);
        } else {
            ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableErrorResponse.class);
            result = ImmutableRefundListResponse.builder().errorResponse(errorResponse).build();
        }
        return result;
    }
}

