/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.BankAccountsApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.BankAccount;
import org.wisepersist.pinpayments.pojo.BankAccountResponse;
import org.wisepersist.pinpayments.pojo.ImmutableBankAccountResponse;

public class BankAccountsApiImpl
extends AbstractBaseApi
implements BankAccountsApi {
    private static final Logger log = LoggerFactory.getLogger(BankAccountsApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final BankAccountResponse create(BankAccount bankAccount) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(bankAccount);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (BankAccountResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableBankAccountResponse.class);
    }

    @Override
    protected final String getApiName() {
        return "bank_accounts";
    }
}

