/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.TransfersApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.ImmutableTransferLineItemListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableTransferListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableTransferResponse;
import org.wisepersist.pinpayments.pojo.SearchCriteria;
import org.wisepersist.pinpayments.pojo.Transfer;
import org.wisepersist.pinpayments.pojo.TransferLineItemListResponse;
import org.wisepersist.pinpayments.pojo.TransferListResponse;
import org.wisepersist.pinpayments.pojo.TransferResponse;

public class TransfersApiImpl
extends AbstractBaseApi
implements TransfersApi {
    private static final Logger log = LoggerFactory.getLogger(TransfersApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final TransferResponse create(Transfer transfer) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(transfer);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (TransferResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableTransferResponse.class);
    }

    @Override
    public final TransferListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableTransferListResponse.class);
    }

    @Override
    public final TransferListResponse search(SearchCriteria searchCriteria) throws IOException {
        return this.executeSearch(this.getApiUrl(), searchCriteria, ImmutableTransferListResponse.class);
    }

    @Override
    public final TransferResponse fetch(String transferToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), transferToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (TransferResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableTransferResponse.class);
    }

    @Override
    public final TransferLineItemListResponse listLineItems(String transferToken, int page) throws IOException {
        String url = String.format("%s/%s/line_items", this.getApiUrl(), transferToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (TransferLineItemListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableTransferLineItemListResponse.class);
    }

    @Override
    protected final String getApiName() {
        return "transfers";
    }
}

