/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.Balance;
import org.wisepersist.pinpayments.pojo.ImmutableBalance;

@ParametersAreNonnullByDefault
public final class GsonAdaptersBalance
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (BalanceTypeAdapter.adapts(type)) {
            return new BalanceTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersBalance(Balance)";
    }

    private static class BalanceTypeAdapter
    extends TypeAdapter<Balance> {
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Integer> amountTypeAdapter;

        BalanceTypeAdapter(Gson gson) {
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Balance.class == type.getRawType() || ImmutableBalance.class == type.getRawType();
        }

        public void write(JsonWriter out, Balance value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeBalance(out, value);
            }
        }

        public Balance read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readBalance(in);
        }

        private void writeBalance(JsonWriter out, Balance instance) throws IOException {
            out.beginObject();
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            out.name("currency");
            out.value(instance.currency());
            out.endObject();
        }

        private Balance readBalance(JsonReader in) throws IOException {
            ImmutableBalance.Builder builder = ImmutableBalance.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableBalance.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
                case 'c': {
                    if (!"currency".equals(attributeName)) break;
                    this.readInCurrency(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInAmount(JsonReader in, ImmutableBalance.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }

        private void readInCurrency(JsonReader in, ImmutableBalance.Builder builder) throws IOException {
            builder.currency(in.nextString());
        }
    }
}

