/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.BankAccount;
import org.wisepersist.pinpayments.pojo.ImmutableBankAccount;

@ParametersAreNonnullByDefault
public final class GsonAdaptersBankAccount
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (BankAccountTypeAdapter.adapts(type)) {
            return new BankAccountTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersBankAccount(BankAccount)";
    }

    private static class BankAccountTypeAdapter
    extends TypeAdapter<BankAccount> {
        BankAccountTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return BankAccount.class == type.getRawType() || ImmutableBankAccount.class == type.getRawType();
        }

        public void write(JsonWriter out, BankAccount value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeBankAccount(out, value);
            }
        }

        public BankAccount read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readBankAccount(in);
        }

        private void writeBankAccount(JsonWriter out, BankAccount instance) throws IOException {
            out.beginObject();
            String bankNameValue = instance.bankName();
            if (bankNameValue != null) {
                out.name("bank_name");
                out.value(bankNameValue);
            } else if (out.getSerializeNulls()) {
                out.name("bank_name");
                out.nullValue();
            }
            out.name("name");
            out.value(instance.name());
            out.name("bsb");
            out.value(instance.bsb());
            out.name("number");
            out.value(instance.number());
            out.endObject();
        }

        private BankAccount readBankAccount(JsonReader in) throws IOException {
            ImmutableBankAccount.Builder builder = ImmutableBankAccount.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableBankAccount.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'b': {
                    if ("bank_name".equals(attributeName)) {
                        this.readInBankName(in, builder);
                        return;
                    }
                    if (!"bsb".equals(attributeName)) break;
                    this.readInBsb(in, builder);
                    return;
                }
                case 'n': {
                    if ("name".equals(attributeName)) {
                        this.readInName(in, builder);
                        return;
                    }
                    if (!"number".equals(attributeName)) break;
                    this.readInNumber(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInBankName(JsonReader in, ImmutableBankAccount.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.bankName(in.nextString());
            }
        }

        private void readInName(JsonReader in, ImmutableBankAccount.Builder builder) throws IOException {
            builder.name(in.nextString());
        }

        private void readInBsb(JsonReader in, ImmutableBankAccount.Builder builder) throws IOException {
            builder.bsb(in.nextString());
        }

        private void readInNumber(JsonReader in, ImmutableBankAccount.Builder builder) throws IOException {
            builder.number(in.nextString());
        }
    }
}

