/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCardResponse;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCardResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CardResponseTypeAdapter.adapts(type)) {
            return new CardResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCardResponse(CardResponse)";
    }

    private static class CardResponseTypeAdapter
    extends TypeAdapter<CardResponse> {
        public final CardResult responseTypeSample = null;
        public final ErrorResponse errorResponseTypeSample = null;
        private final TypeAdapter<CardResult> responseTypeAdapter;
        private final TypeAdapter<ErrorResponse> errorResponseTypeAdapter;

        CardResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(CardResult.class);
            this.errorResponseTypeAdapter = gson.getAdapter(ErrorResponse.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return CardResponse.class == type.getRawType() || ImmutableCardResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, CardResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCardResponse(out, value);
            }
        }

        public CardResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCardResponse(in);
        }

        private void writeCardResponse(JsonWriter out, CardResponse instance) throws IOException {
            out.beginObject();
            CardResult responseValue = instance.response();
            if (responseValue != null) {
                out.name("response");
                this.responseTypeAdapter.write(out, (Object)responseValue);
            } else if (out.getSerializeNulls()) {
                out.name("response");
                out.nullValue();
            }
            ErrorResponse errorResponseValue = instance.errorResponse();
            if (errorResponseValue != null) {
                out.name("errorResponse");
                this.errorResponseTypeAdapter.write(out, (Object)errorResponseValue);
            } else if (out.getSerializeNulls()) {
                out.name("errorResponse");
                out.nullValue();
            }
            out.endObject();
        }

        private CardResponse readCardResponse(JsonReader in) throws IOException {
            ImmutableCardResponse.Builder builder = ImmutableCardResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCardResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'e': {
                    if (!"errorResponse".equals(attributeName)) break;
                    this.readInErrorResponse(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableCardResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                CardResult value = (CardResult)this.responseTypeAdapter.read(in);
                builder.response(value);
            }
        }

        private void readInErrorResponse(JsonReader in, ImmutableCardResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ErrorResponse value = (ErrorResponse)this.errorResponseTypeAdapter.read(in);
                builder.errorResponse(value);
            }
        }
    }
}

