/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.Charge;
import org.wisepersist.pinpayments.pojo.ImmutableCharge;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCharge
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ChargeTypeAdapter.adapts(type)) {
            return new ChargeTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCharge(Charge)";
    }

    private static class ChargeTypeAdapter
    extends TypeAdapter<Charge> {
        public final Card cardTypeSample = null;
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Card> cardTypeAdapter;
        private final TypeAdapter<Integer> amountTypeAdapter;

        ChargeTypeAdapter(Gson gson) {
            this.cardTypeAdapter = gson.getAdapter(Card.class);
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Charge.class == type.getRawType() || ImmutableCharge.class == type.getRawType();
        }

        public void write(JsonWriter out, Charge value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCharge(out, value);
            }
        }

        public Charge read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCharge(in);
        }

        private void writeCharge(JsonWriter out, Charge instance) throws IOException {
            out.beginObject();
            String captureValue = instance.capture();
            if (captureValue != null) {
                out.name("capture");
                out.value(captureValue);
            } else if (out.getSerializeNulls()) {
                out.name("capture");
                out.nullValue();
            }
            Card cardValue = instance.card();
            if (cardValue != null) {
                out.name("card");
                this.cardTypeAdapter.write(out, (Object)cardValue);
            } else if (out.getSerializeNulls()) {
                out.name("card");
                out.nullValue();
            }
            String cardTokenValue = instance.cardToken();
            if (cardTokenValue != null) {
                out.name("card_token");
                out.value(cardTokenValue);
            } else if (out.getSerializeNulls()) {
                out.name("card_token");
                out.nullValue();
            }
            String customerTokenValue = instance.customerToken();
            if (customerTokenValue != null) {
                out.name("customer_token");
                out.value(customerTokenValue);
            } else if (out.getSerializeNulls()) {
                out.name("customer_token");
                out.nullValue();
            }
            out.name("email");
            out.value(instance.email());
            out.name("description");
            out.value(instance.description());
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            String ipAddressValue = instance.ipAddress();
            if (ipAddressValue != null) {
                out.name("ip_address");
                out.value(ipAddressValue);
            } else if (out.getSerializeNulls()) {
                out.name("ip_address");
                out.nullValue();
            }
            out.name("currency");
            out.value(instance.currency());
            Map<String, String> metadataMapping = instance.metadata();
            out.name("metadata");
            out.beginObject();
            for (Map.Entry<String, String> e : metadataMapping.entrySet()) {
                String key = e.getKey();
                out.name(key);
                String value = e.getValue();
                out.value(value);
            }
            out.endObject();
            out.endObject();
        }

        private Charge readCharge(JsonReader in) throws IOException {
            ImmutableCharge.Builder builder = ImmutableCharge.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'c': {
                    if ("capture".equals(attributeName)) {
                        this.readInCapture(in, builder);
                        return;
                    }
                    if ("card".equals(attributeName)) {
                        this.readInCard(in, builder);
                        return;
                    }
                    if ("card_token".equals(attributeName)) {
                        this.readInCardToken(in, builder);
                        return;
                    }
                    if ("customer_token".equals(attributeName)) {
                        this.readInCustomerToken(in, builder);
                        return;
                    }
                    if (!"currency".equals(attributeName)) break;
                    this.readInCurrency(in, builder);
                    return;
                }
                case 'e': {
                    if (!"email".equals(attributeName)) break;
                    this.readInEmail(in, builder);
                    return;
                }
                case 'd': {
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
                case 'i': {
                    if (!"ip_address".equals(attributeName)) break;
                    this.readInIpAddress(in, builder);
                    return;
                }
                case 'm': {
                    if (!"metadata".equals(attributeName)) break;
                    this.readInMetadata(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInCapture(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.capture(in.nextString());
            }
        }

        private void readInCard(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Card value = (Card)this.cardTypeAdapter.read(in);
                builder.card(value);
            }
        }

        private void readInCardToken(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.cardToken(in.nextString());
            }
        }

        private void readInCustomerToken(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.customerToken(in.nextString());
            }
        }

        private void readInEmail(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            builder.email(in.nextString());
        }

        private void readInDescription(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            builder.description(in.nextString());
        }

        private void readInAmount(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }

        private void readInIpAddress(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.ipAddress(in.nextString());
            }
        }

        private void readInCurrency(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            builder.currency(in.nextString());
        }

        private void readInMetadata(JsonReader in, ImmutableCharge.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putMetadata(key, value);
                }
                in.endObject();
            }
        }
    }
}

