/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.ChargeResult;
import org.wisepersist.pinpayments.pojo.ImmutableChargeResult;
import org.wisepersist.pinpayments.pojo.Transfer;

@ParametersAreNonnullByDefault
public final class GsonAdaptersChargeResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ChargeResultTypeAdapter.adapts(type)) {
            return new ChargeResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersChargeResult(ChargeResult)";
    }

    private static class ChargeResultTypeAdapter
    extends TypeAdapter<ChargeResult> {
        public final CardResult cardTypeSample = null;
        public final Transfer transferTypeSample = null;
        public final BigDecimal amountRefundedTypeSample = null;
        public final BigDecimal totalFeesTypeSample = null;
        public final BigDecimal merchantEntitlementTypeSample = null;
        public final Integer amountTypeSample = null;
        private final TypeAdapter<CardResult> cardTypeAdapter;
        private final TypeAdapter<Transfer> transferTypeAdapter;
        private final TypeAdapter<BigDecimal> amountRefundedTypeAdapter;
        private final TypeAdapter<BigDecimal> totalFeesTypeAdapter;
        private final TypeAdapter<BigDecimal> merchantEntitlementTypeAdapter;
        private final TypeAdapter<Integer> amountTypeAdapter;

        ChargeResultTypeAdapter(Gson gson) {
            this.cardTypeAdapter = gson.getAdapter(CardResult.class);
            this.transferTypeAdapter = gson.getAdapter(Transfer.class);
            this.amountRefundedTypeAdapter = gson.getAdapter(BigDecimal.class);
            this.totalFeesTypeAdapter = gson.getAdapter(BigDecimal.class);
            this.merchantEntitlementTypeAdapter = gson.getAdapter(BigDecimal.class);
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return ChargeResult.class == type.getRawType() || ImmutableChargeResult.class == type.getRawType();
        }

        public void write(JsonWriter out, ChargeResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeChargeResult(out, value);
            }
        }

        public ChargeResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readChargeResult(in);
        }

        private void writeChargeResult(JsonWriter out, ChargeResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            out.name("success");
            out.value(instance.success());
            out.name("created_at");
            out.value(instance.createdAt());
            out.name("status_message");
            out.value(instance.statusMessage());
            String errorMessageValue = instance.errorMessage();
            if (errorMessageValue != null) {
                out.name("error_message");
                out.value(errorMessageValue);
            } else if (out.getSerializeNulls()) {
                out.name("error_message");
                out.nullValue();
            }
            out.name("card");
            this.cardTypeAdapter.write(out, (Object)instance.card());
            out.name("captured");
            out.value(instance.captured());
            out.name("authorisation_expired");
            out.value(instance.authorisationExpired());
            List<Transfer> transferElements = instance.transfer();
            out.name("transfer");
            out.beginArray();
            for (Transfer e : transferElements) {
                this.transferTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("amount_refunded");
            this.amountRefundedTypeAdapter.write(out, (Object)instance.amountRefunded());
            BigDecimal totalFeesValue = instance.totalFees();
            if (totalFeesValue != null) {
                out.name("total_fees");
                this.totalFeesTypeAdapter.write(out, (Object)totalFeesValue);
            } else if (out.getSerializeNulls()) {
                out.name("total_fees");
                out.nullValue();
            }
            BigDecimal merchantEntitlementValue = instance.merchantEntitlement();
            if (merchantEntitlementValue != null) {
                out.name("merchant_entitlement");
                this.merchantEntitlementTypeAdapter.write(out, (Object)merchantEntitlementValue);
            } else if (out.getSerializeNulls()) {
                out.name("merchant_entitlement");
                out.nullValue();
            }
            out.name("refund_pending");
            out.value(instance.refundPending());
            out.name("settlement_currency");
            out.value(instance.settlementCurrency());
            out.name("email");
            out.value(instance.email());
            out.name("description");
            out.value(instance.description());
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            String ipAddressValue = instance.ipAddress();
            if (ipAddressValue != null) {
                out.name("ip_address");
                out.value(ipAddressValue);
            } else if (out.getSerializeNulls()) {
                out.name("ip_address");
                out.nullValue();
            }
            out.name("currency");
            out.value(instance.currency());
            Map<String, String> metadataMapping = instance.metadata();
            out.name("metadata");
            out.beginObject();
            for (Map.Entry<String, String> e : metadataMapping.entrySet()) {
                String key = e.getKey();
                out.name(key);
                String value = e.getValue();
                out.value(value);
            }
            out.endObject();
            out.endObject();
        }

        private ChargeResult readChargeResult(JsonReader in) throws IOException {
            ImmutableChargeResult.Builder builder = ImmutableChargeResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if ("token".equals(attributeName)) {
                        this.readInToken(in, builder);
                        return;
                    }
                    if ("transfer".equals(attributeName)) {
                        this.readInTransfer(in, builder);
                        return;
                    }
                    if (!"total_fees".equals(attributeName)) break;
                    this.readInTotalFees(in, builder);
                    return;
                }
                case 's': {
                    if ("success".equals(attributeName)) {
                        this.readInSuccess(in, builder);
                        return;
                    }
                    if ("status_message".equals(attributeName)) {
                        this.readInStatusMessage(in, builder);
                        return;
                    }
                    if (!"settlement_currency".equals(attributeName)) break;
                    this.readInSettlementCurrency(in, builder);
                    return;
                }
                case 'c': {
                    if ("created_at".equals(attributeName)) {
                        this.readInCreatedAt(in, builder);
                        return;
                    }
                    if ("card".equals(attributeName)) {
                        this.readInCard(in, builder);
                        return;
                    }
                    if ("captured".equals(attributeName)) {
                        this.readInCaptured(in, builder);
                        return;
                    }
                    if (!"currency".equals(attributeName)) break;
                    this.readInCurrency(in, builder);
                    return;
                }
                case 'e': {
                    if ("error_message".equals(attributeName)) {
                        this.readInErrorMessage(in, builder);
                        return;
                    }
                    if (!"email".equals(attributeName)) break;
                    this.readInEmail(in, builder);
                    return;
                }
                case 'a': {
                    if ("authorisation_expired".equals(attributeName)) {
                        this.readInAuthorisationExpired(in, builder);
                        return;
                    }
                    if ("amount_refunded".equals(attributeName)) {
                        this.readInAmountRefunded(in, builder);
                        return;
                    }
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
                case 'm': {
                    if ("merchant_entitlement".equals(attributeName)) {
                        this.readInMerchantEntitlement(in, builder);
                        return;
                    }
                    if (!"metadata".equals(attributeName)) break;
                    this.readInMetadata(in, builder);
                    return;
                }
                case 'r': {
                    if (!"refund_pending".equals(attributeName)) break;
                    this.readInRefundPending(in, builder);
                    return;
                }
                case 'd': {
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
                case 'i': {
                    if (!"ip_address".equals(attributeName)) break;
                    this.readInIpAddress(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInSuccess(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.success(in.nextBoolean());
        }

        private void readInCreatedAt(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }

        private void readInStatusMessage(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.statusMessage(in.nextString());
        }

        private void readInErrorMessage(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.errorMessage(in.nextString());
            }
        }

        private void readInCard(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            CardResult value = (CardResult)this.cardTypeAdapter.read(in);
            builder.card(value);
        }

        private void readInCaptured(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.captured(in.nextBoolean());
        }

        private void readInAuthorisationExpired(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.authorisationExpired(in.nextBoolean());
        }

        private void readInTransfer(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Transfer value = (Transfer)this.transferTypeAdapter.read(in);
                    builder.addTransfer(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Transfer value = (Transfer)this.transferTypeAdapter.read(in);
                builder.addTransfer(value);
            }
        }

        private void readInAmountRefunded(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            BigDecimal value = (BigDecimal)this.amountRefundedTypeAdapter.read(in);
            builder.amountRefunded(value);
        }

        private void readInTotalFees(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                BigDecimal value = (BigDecimal)this.totalFeesTypeAdapter.read(in);
                builder.totalFees(value);
            }
        }

        private void readInMerchantEntitlement(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                BigDecimal value = (BigDecimal)this.merchantEntitlementTypeAdapter.read(in);
                builder.merchantEntitlement(value);
            }
        }

        private void readInRefundPending(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.refundPending(in.nextBoolean());
        }

        private void readInSettlementCurrency(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.settlementCurrency(in.nextString());
        }

        private void readInEmail(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.email(in.nextString());
        }

        private void readInDescription(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.description(in.nextString());
        }

        private void readInAmount(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }

        private void readInIpAddress(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.ipAddress(in.nextString());
            }
        }

        private void readInCurrency(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            builder.currency(in.nextString());
        }

        private void readInMetadata(JsonReader in, ImmutableChargeResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putMetadata(key, value);
                }
                in.endObject();
            }
        }
    }
}

