/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.CustomerListResponse;
import org.wisepersist.pinpayments.pojo.CustomerResult;
import org.wisepersist.pinpayments.pojo.ImmutableCustomerListResponse;
import org.wisepersist.pinpayments.pojo.Pagination;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCustomerListResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CustomerListResponseTypeAdapter.adapts(type)) {
            return new CustomerListResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCustomerListResponse(CustomerListResponse)";
    }

    private static class CustomerListResponseTypeAdapter
    extends TypeAdapter<CustomerListResponse> {
        public final CustomerResult responseTypeSample = null;
        public final Pagination paginationTypeSample = null;
        private final TypeAdapter<CustomerResult> responseTypeAdapter;
        private final TypeAdapter<Pagination> paginationTypeAdapter;

        CustomerListResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(CustomerResult.class);
            this.paginationTypeAdapter = gson.getAdapter(Pagination.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return CustomerListResponse.class == type.getRawType() || ImmutableCustomerListResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, CustomerListResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCustomerListResponse(out, value);
            }
        }

        public CustomerListResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCustomerListResponse(in);
        }

        private void writeCustomerListResponse(JsonWriter out, CustomerListResponse instance) throws IOException {
            out.beginObject();
            List<CustomerResult> responseElements = instance.response();
            out.name("response");
            out.beginArray();
            for (CustomerResult e : responseElements) {
                this.responseTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("pagination");
            this.paginationTypeAdapter.write(out, (Object)instance.pagination());
            out.endObject();
        }

        private CustomerListResponse readCustomerListResponse(JsonReader in) throws IOException {
            ImmutableCustomerListResponse.Builder builder = ImmutableCustomerListResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCustomerListResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pagination".equals(attributeName)) break;
                    this.readInPagination(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableCustomerListResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    CustomerResult value = (CustomerResult)this.responseTypeAdapter.read(in);
                    builder.addResponse(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                CustomerResult value = (CustomerResult)this.responseTypeAdapter.read(in);
                builder.addResponse(value);
            }
        }

        private void readInPagination(JsonReader in, ImmutableCustomerListResponse.Builder builder) throws IOException {
            Pagination value = (Pagination)this.paginationTypeAdapter.read(in);
            builder.pagination(value);
        }
    }
}

