/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.CustomerResponse;
import org.wisepersist.pinpayments.pojo.CustomerResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCustomerResponse;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCustomerResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CustomerResponseTypeAdapter.adapts(type)) {
            return new CustomerResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCustomerResponse(CustomerResponse)";
    }

    private static class CustomerResponseTypeAdapter
    extends TypeAdapter<CustomerResponse> {
        public final CustomerResult responseTypeSample = null;
        public final ErrorResponse errorResponseTypeSample = null;
        private final TypeAdapter<CustomerResult> responseTypeAdapter;
        private final TypeAdapter<ErrorResponse> errorResponseTypeAdapter;

        CustomerResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(CustomerResult.class);
            this.errorResponseTypeAdapter = gson.getAdapter(ErrorResponse.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return CustomerResponse.class == type.getRawType() || ImmutableCustomerResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, CustomerResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCustomerResponse(out, value);
            }
        }

        public CustomerResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCustomerResponse(in);
        }

        private void writeCustomerResponse(JsonWriter out, CustomerResponse instance) throws IOException {
            out.beginObject();
            CustomerResult responseValue = instance.response();
            if (responseValue != null) {
                out.name("response");
                this.responseTypeAdapter.write(out, (Object)responseValue);
            } else if (out.getSerializeNulls()) {
                out.name("response");
                out.nullValue();
            }
            ErrorResponse errorResponseValue = instance.errorResponse();
            if (errorResponseValue != null) {
                out.name("errorResponse");
                this.errorResponseTypeAdapter.write(out, (Object)errorResponseValue);
            } else if (out.getSerializeNulls()) {
                out.name("errorResponse");
                out.nullValue();
            }
            out.endObject();
        }

        private CustomerResponse readCustomerResponse(JsonReader in) throws IOException {
            ImmutableCustomerResponse.Builder builder = ImmutableCustomerResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCustomerResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'e': {
                    if (!"errorResponse".equals(attributeName)) break;
                    this.readInErrorResponse(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableCustomerResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                CustomerResult value = (CustomerResult)this.responseTypeAdapter.read(in);
                builder.response(value);
            }
        }

        private void readInErrorResponse(JsonReader in, ImmutableCustomerResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ErrorResponse value = (ErrorResponse)this.errorResponseTypeAdapter.read(in);
                builder.errorResponse(value);
            }
        }
    }
}

