/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ErrorMessage;
import org.wisepersist.pinpayments.pojo.ImmutableErrorMessage;

@ParametersAreNonnullByDefault
public final class GsonAdaptersErrorMessage
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ErrorMessageTypeAdapter.adapts(type)) {
            return new ErrorMessageTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersErrorMessage(ErrorMessage)";
    }

    private static class ErrorMessageTypeAdapter
    extends TypeAdapter<ErrorMessage> {
        ErrorMessageTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return ErrorMessage.class == type.getRawType() || ImmutableErrorMessage.class == type.getRawType();
        }

        public void write(JsonWriter out, ErrorMessage value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeErrorMessage(out, value);
            }
        }

        public ErrorMessage read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readErrorMessage(in);
        }

        private void writeErrorMessage(JsonWriter out, ErrorMessage instance) throws IOException {
            out.beginObject();
            out.name("param");
            out.value(instance.param());
            out.name("code");
            out.value(instance.code());
            out.name("message");
            out.value(instance.message());
            out.endObject();
        }

        private ErrorMessage readErrorMessage(JsonReader in) throws IOException {
            ImmutableErrorMessage.Builder builder = ImmutableErrorMessage.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableErrorMessage.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'p': {
                    if (!"param".equals(attributeName)) break;
                    this.readInParam(in, builder);
                    return;
                }
                case 'c': {
                    if (!"code".equals(attributeName)) break;
                    this.readInCode(in, builder);
                    return;
                }
                case 'm': {
                    if (!"message".equals(attributeName)) break;
                    this.readInMessage(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInParam(JsonReader in, ImmutableErrorMessage.Builder builder) throws IOException {
            builder.param(in.nextString());
        }

        private void readInCode(JsonReader in, ImmutableErrorMessage.Builder builder) throws IOException {
            builder.code(in.nextString());
        }

        private void readInMessage(JsonReader in, ImmutableErrorMessage.Builder builder) throws IOException {
            builder.message(in.nextString());
        }
    }
}

