/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableRecipientListResponse;
import org.wisepersist.pinpayments.pojo.Pagination;
import org.wisepersist.pinpayments.pojo.RecipientListResponse;
import org.wisepersist.pinpayments.pojo.RecipientResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersRecipientListResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (RecipientListResponseTypeAdapter.adapts(type)) {
            return new RecipientListResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRecipientListResponse(RecipientListResponse)";
    }

    private static class RecipientListResponseTypeAdapter
    extends TypeAdapter<RecipientListResponse> {
        public final RecipientResult responseTypeSample = null;
        public final Pagination paginationTypeSample = null;
        private final TypeAdapter<RecipientResult> responseTypeAdapter;
        private final TypeAdapter<Pagination> paginationTypeAdapter;

        RecipientListResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(RecipientResult.class);
            this.paginationTypeAdapter = gson.getAdapter(Pagination.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RecipientListResponse.class == type.getRawType() || ImmutableRecipientListResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, RecipientListResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRecipientListResponse(out, value);
            }
        }

        public RecipientListResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readRecipientListResponse(in);
        }

        private void writeRecipientListResponse(JsonWriter out, RecipientListResponse instance) throws IOException {
            out.beginObject();
            List<RecipientResult> responseElements = instance.response();
            out.name("response");
            out.beginArray();
            for (RecipientResult e : responseElements) {
                this.responseTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("pagination");
            this.paginationTypeAdapter.write(out, (Object)instance.pagination());
            out.endObject();
        }

        private RecipientListResponse readRecipientListResponse(JsonReader in) throws IOException {
            ImmutableRecipientListResponse.Builder builder = ImmutableRecipientListResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRecipientListResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pagination".equals(attributeName)) break;
                    this.readInPagination(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableRecipientListResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    RecipientResult value = (RecipientResult)this.responseTypeAdapter.read(in);
                    builder.addResponse(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                RecipientResult value = (RecipientResult)this.responseTypeAdapter.read(in);
                builder.addResponse(value);
            }
        }

        private void readInPagination(JsonReader in, ImmutableRecipientListResponse.Builder builder) throws IOException {
            Pagination value = (Pagination)this.paginationTypeAdapter.read(in);
            builder.pagination(value);
        }
    }
}

