/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableRefund;
import org.wisepersist.pinpayments.pojo.Refund;

@ParametersAreNonnullByDefault
public final class GsonAdaptersRefund
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (RefundTypeAdapter.adapts(type)) {
            return new RefundTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRefund(Refund)";
    }

    private static class RefundTypeAdapter
    extends TypeAdapter<Refund> {
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Integer> amountTypeAdapter;

        RefundTypeAdapter(Gson gson) {
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Refund.class == type.getRawType() || ImmutableRefund.class == type.getRawType();
        }

        public void write(JsonWriter out, Refund value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRefund(out, value);
            }
        }

        public Refund read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readRefund(in);
        }

        private void writeRefund(JsonWriter out, Refund instance) throws IOException {
            out.beginObject();
            Integer amountValue = instance.amount();
            if (amountValue != null) {
                out.name("amount");
                this.amountTypeAdapter.write(out, (Object)amountValue);
            } else if (out.getSerializeNulls()) {
                out.name("amount");
                out.nullValue();
            }
            out.endObject();
        }

        private Refund readRefund(JsonReader in) throws IOException {
            ImmutableRefund.Builder builder = ImmutableRefund.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRefund.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInAmount(JsonReader in, ImmutableRefund.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = (Integer)this.amountTypeAdapter.read(in);
                builder.amount(value);
            }
        }
    }
}

