/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.ImmutableRefundResponse;
import org.wisepersist.pinpayments.pojo.RefundResponse;
import org.wisepersist.pinpayments.pojo.RefundResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersRefundResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (RefundResponseTypeAdapter.adapts(type)) {
            return new RefundResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRefundResponse(RefundResponse)";
    }

    private static class RefundResponseTypeAdapter
    extends TypeAdapter<RefundResponse> {
        public final RefundResult responseTypeSample = null;
        public final ErrorResponse errorResponseTypeSample = null;
        private final TypeAdapter<RefundResult> responseTypeAdapter;
        private final TypeAdapter<ErrorResponse> errorResponseTypeAdapter;

        RefundResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(RefundResult.class);
            this.errorResponseTypeAdapter = gson.getAdapter(ErrorResponse.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RefundResponse.class == type.getRawType() || ImmutableRefundResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, RefundResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRefundResponse(out, value);
            }
        }

        public RefundResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readRefundResponse(in);
        }

        private void writeRefundResponse(JsonWriter out, RefundResponse instance) throws IOException {
            out.beginObject();
            RefundResult responseValue = instance.response();
            if (responseValue != null) {
                out.name("response");
                this.responseTypeAdapter.write(out, (Object)responseValue);
            } else if (out.getSerializeNulls()) {
                out.name("response");
                out.nullValue();
            }
            ErrorResponse errorResponseValue = instance.errorResponse();
            if (errorResponseValue != null) {
                out.name("errorResponse");
                this.errorResponseTypeAdapter.write(out, (Object)errorResponseValue);
            } else if (out.getSerializeNulls()) {
                out.name("errorResponse");
                out.nullValue();
            }
            out.endObject();
        }

        private RefundResponse readRefundResponse(JsonReader in) throws IOException {
            ImmutableRefundResponse.Builder builder = ImmutableRefundResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRefundResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'e': {
                    if (!"errorResponse".equals(attributeName)) break;
                    this.readInErrorResponse(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableRefundResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                RefundResult value = (RefundResult)this.responseTypeAdapter.read(in);
                builder.response(value);
            }
        }

        private void readInErrorResponse(JsonReader in, ImmutableRefundResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ErrorResponse value = (ErrorResponse)this.errorResponseTypeAdapter.read(in);
                builder.errorResponse(value);
            }
        }
    }
}

