/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.wisepersist.pinpayments.pojo.ImmutableSearchCriteria;
import org.wisepersist.pinpayments.pojo.SearchCriteria;

@ParametersAreNonnullByDefault
public final class GsonAdaptersSearchCriteria
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SearchCriteriaTypeAdapter.adapts(type)) {
            return new SearchCriteriaTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSearchCriteria(SearchCriteria)";
    }

    private static class SearchCriteriaTypeAdapter
    extends TypeAdapter<SearchCriteria> {
        public final DateTime startDateTypeSample = null;
        public final DateTime endDateTypeSample = null;
        private final TypeAdapter<DateTime> startDateTypeAdapter;
        private final TypeAdapter<DateTime> endDateTypeAdapter;

        SearchCriteriaTypeAdapter(Gson gson) {
            this.startDateTypeAdapter = gson.getAdapter(DateTime.class);
            this.endDateTypeAdapter = gson.getAdapter(DateTime.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return SearchCriteria.class == type.getRawType() || ImmutableSearchCriteria.class == type.getRawType();
        }

        public void write(JsonWriter out, SearchCriteria value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSearchCriteria(out, value);
            }
        }

        public SearchCriteria read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readSearchCriteria(in);
        }

        private void writeSearchCriteria(JsonWriter out, SearchCriteria instance) throws IOException {
            out.beginObject();
            String queryValue = instance.query();
            if (queryValue != null) {
                out.name("query");
                out.value(queryValue);
            } else if (out.getSerializeNulls()) {
                out.name("query");
                out.nullValue();
            }
            DateTime startDateValue = instance.startDate();
            if (startDateValue != null) {
                out.name("start_date");
                this.startDateTypeAdapter.write(out, (Object)startDateValue);
            } else if (out.getSerializeNulls()) {
                out.name("start_date");
                out.nullValue();
            }
            DateTime endDateValue = instance.endDate();
            if (endDateValue != null) {
                out.name("end_date");
                this.endDateTypeAdapter.write(out, (Object)endDateValue);
            } else if (out.getSerializeNulls()) {
                out.name("end_date");
                out.nullValue();
            }
            String sortValue = instance.sort();
            if (sortValue != null) {
                out.name("sort");
                out.value(sortValue);
            } else if (out.getSerializeNulls()) {
                out.name("sort");
                out.nullValue();
            }
            out.name("direction");
            out.value((long)instance.direction());
            out.endObject();
        }

        private SearchCriteria readSearchCriteria(JsonReader in) throws IOException {
            ImmutableSearchCriteria.Builder builder = ImmutableSearchCriteria.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSearchCriteria.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'q': {
                    if (!"query".equals(attributeName)) break;
                    this.readInQuery(in, builder);
                    return;
                }
                case 's': {
                    if ("start_date".equals(attributeName)) {
                        this.readInStartDate(in, builder);
                        return;
                    }
                    if (!"sort".equals(attributeName)) break;
                    this.readInSort(in, builder);
                    return;
                }
                case 'e': {
                    if (!"end_date".equals(attributeName)) break;
                    this.readInEndDate(in, builder);
                    return;
                }
                case 'd': {
                    if (!"direction".equals(attributeName)) break;
                    this.readInDirection(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInQuery(JsonReader in, ImmutableSearchCriteria.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.query(in.nextString());
            }
        }

        private void readInStartDate(JsonReader in, ImmutableSearchCriteria.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                DateTime value = (DateTime)this.startDateTypeAdapter.read(in);
                builder.startDate(value);
            }
        }

        private void readInEndDate(JsonReader in, ImmutableSearchCriteria.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                DateTime value = (DateTime)this.endDateTypeAdapter.read(in);
                builder.endDate(value);
            }
        }

        private void readInSort(JsonReader in, ImmutableSearchCriteria.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.sort(in.nextString());
            }
        }

        private void readInDirection(JsonReader in, ImmutableSearchCriteria.Builder builder) throws IOException {
            builder.direction(in.nextInt());
        }
    }
}

