/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableTransfer;
import org.wisepersist.pinpayments.pojo.Transfer;

@ParametersAreNonnullByDefault
public final class GsonAdaptersTransfer
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (TransferTypeAdapter.adapts(type)) {
            return new TransferTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersTransfer(Transfer)";
    }

    private static class TransferTypeAdapter
    extends TypeAdapter<Transfer> {
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Integer> amountTypeAdapter;

        TransferTypeAdapter(Gson gson) {
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Transfer.class == type.getRawType() || ImmutableTransfer.class == type.getRawType();
        }

        public void write(JsonWriter out, Transfer value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeTransfer(out, value);
            }
        }

        public Transfer read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readTransfer(in);
        }

        private void writeTransfer(JsonWriter out, Transfer instance) throws IOException {
            out.beginObject();
            out.name("description");
            out.value(instance.description());
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            out.name("currency");
            out.value(instance.currency());
            out.name("recipient");
            out.value(instance.recipient());
            out.endObject();
        }

        private Transfer readTransfer(JsonReader in) throws IOException {
            ImmutableTransfer.Builder builder = ImmutableTransfer.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableTransfer.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'd': {
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
                case 'c': {
                    if (!"currency".equals(attributeName)) break;
                    this.readInCurrency(in, builder);
                    return;
                }
                case 'r': {
                    if (!"recipient".equals(attributeName)) break;
                    this.readInRecipient(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInDescription(JsonReader in, ImmutableTransfer.Builder builder) throws IOException {
            builder.description(in.nextString());
        }

        private void readInAmount(JsonReader in, ImmutableTransfer.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }

        private void readInCurrency(JsonReader in, ImmutableTransfer.Builder builder) throws IOException {
            builder.currency(in.nextString());
        }

        private void readInRecipient(JsonReader in, ImmutableTransfer.Builder builder) throws IOException {
            builder.recipient(in.nextString());
        }
    }
}

