/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.BankAccountResult;
import org.wisepersist.pinpayments.pojo.ImmutableTransferResult;
import org.wisepersist.pinpayments.pojo.TransferResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersTransferResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (TransferResultTypeAdapter.adapts(type)) {
            return new TransferResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersTransferResult(TransferResult)";
    }

    private static class TransferResultTypeAdapter
    extends TypeAdapter<TransferResult> {
        public final Integer totalDebitsTypeSample = null;
        public final Integer totalCreditsTypeSample = null;
        public final BankAccountResult bankAccountTypeSample = null;
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Integer> totalDebitsTypeAdapter;
        private final TypeAdapter<Integer> totalCreditsTypeAdapter;
        private final TypeAdapter<BankAccountResult> bankAccountTypeAdapter;
        private final TypeAdapter<Integer> amountTypeAdapter;

        TransferResultTypeAdapter(Gson gson) {
            this.totalDebitsTypeAdapter = gson.getAdapter(Integer.class);
            this.totalCreditsTypeAdapter = gson.getAdapter(Integer.class);
            this.bankAccountTypeAdapter = gson.getAdapter(BankAccountResult.class);
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return TransferResult.class == type.getRawType() || ImmutableTransferResult.class == type.getRawType();
        }

        public void write(JsonWriter out, TransferResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeTransferResult(out, value);
            }
        }

        public TransferResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readTransferResult(in);
        }

        private void writeTransferResult(JsonWriter out, TransferResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            out.name("status");
            out.value(instance.status());
            out.name("total_debits");
            this.totalDebitsTypeAdapter.write(out, (Object)instance.totalDebits());
            out.name("total_credits");
            this.totalCreditsTypeAdapter.write(out, (Object)instance.totalCredits());
            out.name("created_at");
            out.value(instance.createdAt());
            out.name("paid_at");
            out.value(instance.paidAt());
            out.name("bank_account");
            this.bankAccountTypeAdapter.write(out, (Object)instance.bankAccount());
            out.name("description");
            out.value(instance.description());
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            out.name("currency");
            out.value(instance.currency());
            out.name("recipient");
            out.value(instance.recipient());
            out.endObject();
        }

        private TransferResult readTransferResult(JsonReader in) throws IOException {
            ImmutableTransferResult.Builder builder = ImmutableTransferResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if ("token".equals(attributeName)) {
                        this.readInToken(in, builder);
                        return;
                    }
                    if ("total_debits".equals(attributeName)) {
                        this.readInTotalDebits(in, builder);
                        return;
                    }
                    if (!"total_credits".equals(attributeName)) break;
                    this.readInTotalCredits(in, builder);
                    return;
                }
                case 's': {
                    if (!"status".equals(attributeName)) break;
                    this.readInStatus(in, builder);
                    return;
                }
                case 'c': {
                    if ("created_at".equals(attributeName)) {
                        this.readInCreatedAt(in, builder);
                        return;
                    }
                    if (!"currency".equals(attributeName)) break;
                    this.readInCurrency(in, builder);
                    return;
                }
                case 'p': {
                    if (!"paid_at".equals(attributeName)) break;
                    this.readInPaidAt(in, builder);
                    return;
                }
                case 'b': {
                    if (!"bank_account".equals(attributeName)) break;
                    this.readInBankAccount(in, builder);
                    return;
                }
                case 'd': {
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
                case 'r': {
                    if (!"recipient".equals(attributeName)) break;
                    this.readInRecipient(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInStatus(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            builder.status(in.nextString());
        }

        private void readInTotalDebits(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            Integer value = (Integer)this.totalDebitsTypeAdapter.read(in);
            builder.totalDebits(value);
        }

        private void readInTotalCredits(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            Integer value = (Integer)this.totalCreditsTypeAdapter.read(in);
            builder.totalCredits(value);
        }

        private void readInCreatedAt(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }

        private void readInPaidAt(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            builder.paidAt(in.nextString());
        }

        private void readInBankAccount(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            BankAccountResult value = (BankAccountResult)this.bankAccountTypeAdapter.read(in);
            builder.bankAccount(value);
        }

        private void readInDescription(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            builder.description(in.nextString());
        }

        private void readInAmount(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }

        private void readInCurrency(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            builder.currency(in.nextString());
        }

        private void readInRecipient(JsonReader in, ImmutableTransferResult.Builder builder) throws IOException {
            builder.recipient(in.nextString());
        }
    }
}

