/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Balance;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableBalance
implements Balance {
    private final Integer amount;
    private final String currency;

    private ImmutableBalance(Integer amount, String currency) {
        this.amount = amount;
        this.currency = currency;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    public final ImmutableBalance withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableBalance(newValue, this.currency);
    }

    public final ImmutableBalance withCurrency(String value) {
        if (this.currency.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"currency");
        return new ImmutableBalance(this.amount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBalance && this.equalTo((ImmutableBalance)another);
    }

    private boolean equalTo(ImmutableBalance another) {
        return this.amount.equals(another.amount) && this.currency.equals(another.currency);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.currency.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Balance").omitNullValues().add("amount", (Object)this.amount).add("currency", (Object)this.currency).toString();
    }

    public static ImmutableBalance copyOf(Balance instance) {
        if (instance instanceof ImmutableBalance) {
            return (ImmutableBalance)instance;
        }
        return ImmutableBalance.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AMOUNT = 1L;
        private static final long INIT_BIT_CURRENCY = 2L;
        private long initBits = 3L;
        @Nullable
        private Integer amount;
        @Nullable
        private String currency;

        private Builder() {
        }

        public final Builder from(Balance instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.amount(instance.amount());
            this.currency(instance.currency());
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBalance build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBalance(this.amount, this.currency);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("currency");
            }
            return "Cannot build Balance, some of required attributes are not set " + attributes;
        }
    }
}

