/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.BalanceResponse;
import org.wisepersist.pinpayments.pojo.BalanceResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableBalanceResponse
implements BalanceResponse {
    private final BalanceResult response;

    private ImmutableBalanceResponse(BalanceResult response) {
        this.response = response;
    }

    @Override
    public BalanceResult response() {
        return this.response;
    }

    public final ImmutableBalanceResponse withResponse(BalanceResult value) {
        if (this.response == value) {
            return this;
        }
        BalanceResult newValue = (BalanceResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableBalanceResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBalanceResponse && this.equalTo((ImmutableBalanceResponse)another);
    }

    private boolean equalTo(ImmutableBalanceResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BalanceResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableBalanceResponse copyOf(BalanceResponse instance) {
        if (instance instanceof ImmutableBalanceResponse) {
            return (ImmutableBalanceResponse)instance;
        }
        return ImmutableBalanceResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private BalanceResult response;

        private Builder() {
        }

        public final Builder from(BalanceResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(BalanceResult response) {
            this.response = (BalanceResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBalanceResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBalanceResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build BalanceResponse, some of required attributes are not set " + attributes;
        }
    }
}

