/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.BankAccountResponse;
import org.wisepersist.pinpayments.pojo.BankAccountResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableBankAccountResponse
implements BankAccountResponse {
    private final BankAccountResult response;

    private ImmutableBankAccountResponse(BankAccountResult response) {
        this.response = response;
    }

    @Override
    public BankAccountResult response() {
        return this.response;
    }

    public final ImmutableBankAccountResponse withResponse(BankAccountResult value) {
        if (this.response == value) {
            return this;
        }
        BankAccountResult newValue = (BankAccountResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableBankAccountResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBankAccountResponse && this.equalTo((ImmutableBankAccountResponse)another);
    }

    private boolean equalTo(ImmutableBankAccountResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BankAccountResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableBankAccountResponse copyOf(BankAccountResponse instance) {
        if (instance instanceof ImmutableBankAccountResponse) {
            return (ImmutableBankAccountResponse)instance;
        }
        return ImmutableBankAccountResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private BankAccountResult response;

        private Builder() {
        }

        public final Builder from(BankAccountResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(BankAccountResult response) {
            this.response = (BankAccountResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBankAccountResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBankAccountResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build BankAccountResponse, some of required attributes are not set " + attributes;
        }
    }
}

