/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CardListResponse;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.Pagination;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCardListResponse
implements CardListResponse {
    @Nullable
    private final ImmutableList<CardResult> response;
    @Nullable
    private final Pagination pagination;
    @Nullable
    private final ErrorResponse errorResponse;

    private ImmutableCardListResponse(@Nullable ImmutableList<CardResult> response, @Nullable Pagination pagination, @Nullable ErrorResponse errorResponse) {
        this.response = response;
        this.pagination = pagination;
        this.errorResponse = errorResponse;
    }

    @Nullable
    public ImmutableList<CardResult> response() {
        return this.response;
    }

    @Override
    @Nullable
    public Pagination pagination() {
        return this.pagination;
    }

    @Override
    @Nullable
    public ErrorResponse errorResponse() {
        return this.errorResponse;
    }

    public final ImmutableCardListResponse withResponse(CardResult ... elements) {
        if (elements == null) {
            return new ImmutableCardListResponse(null, this.pagination, this.errorResponse);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableCardListResponse((ImmutableList<CardResult>)newValue, this.pagination, this.errorResponse);
    }

    public final ImmutableCardListResponse withResponse(@Nullable Iterable<? extends CardResult> elements) {
        if (this.response == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableCardListResponse((ImmutableList<CardResult>)newValue, this.pagination, this.errorResponse);
    }

    public final ImmutableCardListResponse withPagination(@Nullable Pagination value) {
        if (this.pagination == value) {
            return this;
        }
        return new ImmutableCardListResponse(this.response, value, this.errorResponse);
    }

    public final ImmutableCardListResponse withErrorResponse(@Nullable ErrorResponse value) {
        if (this.errorResponse == value) {
            return this;
        }
        return new ImmutableCardListResponse(this.response, this.pagination, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCardListResponse && this.equalTo((ImmutableCardListResponse)another);
    }

    private boolean equalTo(ImmutableCardListResponse another) {
        return Objects.equal(this.response, another.response) && Objects.equal((Object)this.pagination, (Object)another.pagination) && Objects.equal((Object)this.errorResponse, (Object)another.errorResponse);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.response});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.pagination});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorResponse});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CardListResponse").omitNullValues().add("response", this.response).add("pagination", (Object)this.pagination).add("errorResponse", (Object)this.errorResponse).toString();
    }

    public static ImmutableCardListResponse copyOf(CardListResponse instance) {
        if (instance instanceof ImmutableCardListResponse) {
            return (ImmutableCardListResponse)instance;
        }
        return ImmutableCardListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<CardResult> response = null;
        @Nullable
        private Pagination pagination;
        @Nullable
        private ErrorResponse errorResponse;

        private Builder() {
        }

        public final Builder from(CardListResponse instance) {
            ErrorResponse errorResponseValue;
            Pagination paginationValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            List<CardResult> responseValue = instance.response();
            if (responseValue != null) {
                this.addAllResponse(responseValue);
            }
            if ((paginationValue = instance.pagination()) != null) {
                this.pagination(paginationValue);
            }
            if ((errorResponseValue = instance.errorResponse()) != null) {
                this.errorResponse(errorResponseValue);
            }
            return this;
        }

        public final Builder addResponse(CardResult element) {
            if (this.response == null) {
                this.response = ImmutableList.builder();
            }
            this.response.add((Object)element);
            return this;
        }

        public final Builder addResponse(CardResult ... elements) {
            if (this.response == null) {
                this.response = ImmutableList.builder();
            }
            this.response.add((Object[])elements);
            return this;
        }

        public final Builder response(@Nullable Iterable<? extends CardResult> elements) {
            if (elements == null) {
                this.response = null;
                return this;
            }
            this.response = ImmutableList.builder();
            return this.addAllResponse(elements);
        }

        public final Builder addAllResponse(Iterable<? extends CardResult> elements) {
            Preconditions.checkNotNull(elements, (Object)"response element");
            if (this.response == null) {
                this.response = ImmutableList.builder();
            }
            this.response.addAll(elements);
            return this;
        }

        public final Builder pagination(@Nullable Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public final Builder errorResponse(@Nullable ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        public ImmutableCardListResponse build() {
            return new ImmutableCardListResponse(this.response == null ? null : this.response.build(), this.pagination, this.errorResponse);
        }
    }
}

