/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CardBase;
import org.wisepersist.pinpayments.pojo.CardResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCardResult
implements CardResult {
    private final String token;
    private final String scheme;
    private final String displayNumber;
    @Nullable
    private final Boolean primary;
    private final String expiryMonth;
    private final String expiryYear;
    private final String name;
    private final String addressLine1;
    @Nullable
    private final String addressLine2;
    private final String addressCity;
    @Nullable
    private final String addressPostcode;
    @Nullable
    private final String addressState;
    private final String addressCountry;

    private ImmutableCardResult(String token, String scheme, String displayNumber, @Nullable Boolean primary, String expiryMonth, String expiryYear, String name, String addressLine1, @Nullable String addressLine2, String addressCity, @Nullable String addressPostcode, @Nullable String addressState, String addressCountry) {
        this.token = token;
        this.scheme = scheme;
        this.displayNumber = displayNumber;
        this.primary = primary;
        this.expiryMonth = expiryMonth;
        this.expiryYear = expiryYear;
        this.name = name;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.addressCity = addressCity;
        this.addressPostcode = addressPostcode;
        this.addressState = addressState;
        this.addressCountry = addressCountry;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String displayNumber() {
        return this.displayNumber;
    }

    @Override
    @Nullable
    public Boolean primary() {
        return this.primary;
    }

    @Override
    public String expiryMonth() {
        return this.expiryMonth;
    }

    @Override
    public String expiryYear() {
        return this.expiryYear;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String addressLine1() {
        return this.addressLine1;
    }

    @Override
    @Nullable
    public String addressLine2() {
        return this.addressLine2;
    }

    @Override
    public String addressCity() {
        return this.addressCity;
    }

    @Override
    @Nullable
    public String addressPostcode() {
        return this.addressPostcode;
    }

    @Override
    @Nullable
    public String addressState() {
        return this.addressState;
    }

    @Override
    public String addressCountry() {
        return this.addressCountry;
    }

    public final ImmutableCardResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableCardResult(newValue, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withScheme(String value) {
        if (this.scheme.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"scheme");
        return new ImmutableCardResult(this.token, newValue, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withDisplayNumber(String value) {
        if (this.displayNumber.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"displayNumber");
        return new ImmutableCardResult(this.token, this.scheme, newValue, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withPrimary(@Nullable Boolean value) {
        if (Objects.equal((Object)this.primary, (Object)value)) {
            return this;
        }
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, value, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withExpiryMonth(String value) {
        if (this.expiryMonth.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"expiryMonth");
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, newValue, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withExpiryYear(String value) {
        if (this.expiryYear.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"expiryYear");
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, newValue, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, newValue, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withAddressLine1(String value) {
        if (this.addressLine1.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"addressLine1");
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, newValue, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withAddressLine2(@Nullable String value) {
        if (Objects.equal((Object)this.addressLine2, (Object)value)) {
            return this;
        }
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, value, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withAddressCity(String value) {
        if (this.addressCity.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"addressCity");
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, newValue, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withAddressPostcode(@Nullable String value) {
        if (Objects.equal((Object)this.addressPostcode, (Object)value)) {
            return this;
        }
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, value, this.addressState, this.addressCountry);
    }

    public final ImmutableCardResult withAddressState(@Nullable String value) {
        if (Objects.equal((Object)this.addressState, (Object)value)) {
            return this;
        }
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, value, this.addressCountry);
    }

    public final ImmutableCardResult withAddressCountry(String value) {
        if (this.addressCountry.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"addressCountry");
        return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCardResult && this.equalTo((ImmutableCardResult)another);
    }

    private boolean equalTo(ImmutableCardResult another) {
        return this.token.equals(another.token) && this.scheme.equals(another.scheme) && this.displayNumber.equals(another.displayNumber) && Objects.equal((Object)this.primary, (Object)another.primary) && this.expiryMonth.equals(another.expiryMonth) && this.expiryYear.equals(another.expiryYear) && this.name.equals(another.name) && this.addressLine1.equals(another.addressLine1) && Objects.equal((Object)this.addressLine2, (Object)another.addressLine2) && this.addressCity.equals(another.addressCity) && Objects.equal((Object)this.addressPostcode, (Object)another.addressPostcode) && Objects.equal((Object)this.addressState, (Object)another.addressState) && this.addressCountry.equals(another.addressCountry);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.scheme.hashCode();
        h += (h << 5) + this.displayNumber.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.primary});
        h += (h << 5) + this.expiryMonth.hashCode();
        h += (h << 5) + this.expiryYear.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.addressLine1.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.addressLine2});
        h += (h << 5) + this.addressCity.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.addressPostcode});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.addressState});
        h += (h << 5) + this.addressCountry.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CardResult").omitNullValues().add("token", (Object)this.token).add("scheme", (Object)this.scheme).add("displayNumber", (Object)this.displayNumber).add("primary", (Object)this.primary).add("expiryMonth", (Object)this.expiryMonth).add("expiryYear", (Object)this.expiryYear).add("name", (Object)this.name).add("addressLine1", (Object)this.addressLine1).add("addressLine2", (Object)this.addressLine2).add("addressCity", (Object)this.addressCity).add("addressPostcode", (Object)this.addressPostcode).add("addressState", (Object)this.addressState).add("addressCountry", (Object)this.addressCountry).toString();
    }

    public static ImmutableCardResult copyOf(CardResult instance) {
        if (instance instanceof ImmutableCardResult) {
            return (ImmutableCardResult)instance;
        }
        return ImmutableCardResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_SCHEME = 2L;
        private static final long INIT_BIT_DISPLAY_NUMBER = 4L;
        private static final long INIT_BIT_EXPIRY_MONTH = 8L;
        private static final long INIT_BIT_EXPIRY_YEAR = 16L;
        private static final long INIT_BIT_NAME = 32L;
        private static final long INIT_BIT_ADDRESS_LINE1 = 64L;
        private static final long INIT_BIT_ADDRESS_CITY = 128L;
        private static final long INIT_BIT_ADDRESS_COUNTRY = 256L;
        private long initBits = 511L;
        @Nullable
        private String token;
        @Nullable
        private String scheme;
        @Nullable
        private String displayNumber;
        @Nullable
        private Boolean primary;
        @Nullable
        private String expiryMonth;
        @Nullable
        private String expiryYear;
        @Nullable
        private String name;
        @Nullable
        private String addressLine1;
        @Nullable
        private String addressLine2;
        @Nullable
        private String addressCity;
        @Nullable
        private String addressPostcode;
        @Nullable
        private String addressState;
        @Nullable
        private String addressCountry;

        private Builder() {
        }

        public final Builder from(CardResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CardBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CardBase instance;
            if (object instanceof CardResult) {
                instance = (CardResult)object;
                this.displayNumber(instance.displayNumber());
                this.scheme(instance.scheme());
                this.token(instance.token());
                Boolean primaryValue = instance.primary();
                if (primaryValue != null) {
                    this.primary(primaryValue);
                }
            }
            if (object instanceof CardBase) {
                String addressLine2Value;
                instance = (CardBase)object;
                this.addressCountry(instance.addressCountry());
                String addressPostcodeValue = instance.addressPostcode();
                if (addressPostcodeValue != null) {
                    this.addressPostcode(addressPostcodeValue);
                }
                this.expiryMonth(instance.expiryMonth());
                this.name(instance.name());
                this.addressLine1(instance.addressLine1());
                String addressStateValue = instance.addressState();
                if (addressStateValue != null) {
                    this.addressState(addressStateValue);
                }
                if ((addressLine2Value = instance.addressLine2()) != null) {
                    this.addressLine2(addressLine2Value);
                }
                this.expiryYear(instance.expiryYear());
                this.addressCity(instance.addressCity());
            }
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder scheme(String scheme) {
            this.scheme = (String)Preconditions.checkNotNull((Object)scheme, (Object)"scheme");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder displayNumber(String displayNumber) {
            this.displayNumber = (String)Preconditions.checkNotNull((Object)displayNumber, (Object)"displayNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder primary(@Nullable Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final Builder expiryMonth(String expiryMonth) {
            this.expiryMonth = (String)Preconditions.checkNotNull((Object)expiryMonth, (Object)"expiryMonth");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder expiryYear(String expiryYear) {
            this.expiryYear = (String)Preconditions.checkNotNull((Object)expiryYear, (Object)"expiryYear");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = (String)Preconditions.checkNotNull((Object)addressLine1, (Object)"addressLine1");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder addressLine2(@Nullable String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final Builder addressCity(String addressCity) {
            this.addressCity = (String)Preconditions.checkNotNull((Object)addressCity, (Object)"addressCity");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder addressPostcode(@Nullable String addressPostcode) {
            this.addressPostcode = addressPostcode;
            return this;
        }

        public final Builder addressState(@Nullable String addressState) {
            this.addressState = addressState;
            return this;
        }

        public final Builder addressCountry(String addressCountry) {
            this.addressCountry = (String)Preconditions.checkNotNull((Object)addressCountry, (Object)"addressCountry");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public ImmutableCardResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCardResult(this.token, this.scheme, this.displayNumber, this.primary, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scheme");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("displayNumber");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("expiryMonth");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("expiryYear");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("addressLine1");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("addressCity");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("addressCountry");
            }
            return "Cannot build CardResult, some of required attributes are not set " + attributes;
        }
    }
}

