/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.Charge;
import org.wisepersist.pinpayments.pojo.ChargeBase;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCharge
implements Charge {
    @Nullable
    private final String capture;
    @Nullable
    private final Card card;
    @Nullable
    private final String cardToken;
    @Nullable
    private final String customerToken;
    private final String email;
    private final String description;
    private final Integer amount;
    @Nullable
    private final String ipAddress;
    private final String currency;
    private final ImmutableMap<String, String> metadata;

    private ImmutableCharge(@Nullable String capture, @Nullable Card card, @Nullable String cardToken, @Nullable String customerToken, String email, String description, Integer amount, @Nullable String ipAddress, String currency, ImmutableMap<String, String> metadata) {
        this.capture = capture;
        this.card = card;
        this.cardToken = cardToken;
        this.customerToken = customerToken;
        this.email = email;
        this.description = description;
        this.amount = amount;
        this.ipAddress = ipAddress;
        this.currency = currency;
        this.metadata = metadata;
    }

    @Override
    @Nullable
    public String capture() {
        return this.capture;
    }

    @Override
    @Nullable
    public Card card() {
        return this.card;
    }

    @Override
    @Nullable
    public String cardToken() {
        return this.cardToken;
    }

    @Override
    @Nullable
    public String customerToken() {
        return this.customerToken;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    @Override
    @Nullable
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    public ImmutableMap<String, String> metadata() {
        return this.metadata;
    }

    public final ImmutableCharge withCapture(@Nullable String value) {
        if (Objects.equal((Object)this.capture, (Object)value)) {
            return this;
        }
        return new ImmutableCharge(value, this.card, this.cardToken, this.customerToken, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableCharge withCard(@Nullable Card value) {
        if (this.card == value) {
            return this;
        }
        return new ImmutableCharge(this.capture, value, this.cardToken, this.customerToken, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableCharge withCardToken(@Nullable String value) {
        if (Objects.equal((Object)this.cardToken, (Object)value)) {
            return this;
        }
        return new ImmutableCharge(this.capture, this.card, value, this.customerToken, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableCharge withCustomerToken(@Nullable String value) {
        if (Objects.equal((Object)this.customerToken, (Object)value)) {
            return this;
        }
        return new ImmutableCharge(this.capture, this.card, this.cardToken, value, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableCharge withEmail(String value) {
        if (this.email.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"email");
        return new ImmutableCharge(this.capture, this.card, this.cardToken, this.customerToken, newValue, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableCharge withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"description");
        return new ImmutableCharge(this.capture, this.card, this.cardToken, this.customerToken, this.email, newValue, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableCharge withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableCharge(this.capture, this.card, this.cardToken, this.customerToken, this.email, this.description, newValue, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableCharge withIpAddress(@Nullable String value) {
        if (Objects.equal((Object)this.ipAddress, (Object)value)) {
            return this;
        }
        return new ImmutableCharge(this.capture, this.card, this.cardToken, this.customerToken, this.email, this.description, this.amount, value, this.currency, this.metadata);
    }

    public final ImmutableCharge withCurrency(String value) {
        if (this.currency.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"currency");
        return new ImmutableCharge(this.capture, this.card, this.cardToken, this.customerToken, this.email, this.description, this.amount, this.ipAddress, newValue, this.metadata);
    }

    public final ImmutableCharge withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCharge(this.capture, this.card, this.cardToken, this.customerToken, this.email, this.description, this.amount, this.ipAddress, this.currency, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCharge && this.equalTo((ImmutableCharge)another);
    }

    private boolean equalTo(ImmutableCharge another) {
        return Objects.equal((Object)this.capture, (Object)another.capture) && Objects.equal((Object)this.card, (Object)another.card) && Objects.equal((Object)this.cardToken, (Object)another.cardToken) && Objects.equal((Object)this.customerToken, (Object)another.customerToken) && this.email.equals(another.email) && this.description.equals(another.description) && this.amount.equals(another.amount) && Objects.equal((Object)this.ipAddress, (Object)another.ipAddress) && this.currency.equals(another.currency) && this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.capture});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.card});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.cardToken});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.customerToken});
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.ipAddress});
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Charge").omitNullValues().add("capture", (Object)this.capture).add("card", (Object)this.card).add("cardToken", (Object)this.cardToken).add("customerToken", (Object)this.customerToken).add("email", (Object)this.email).add("description", (Object)this.description).add("amount", (Object)this.amount).add("ipAddress", (Object)this.ipAddress).add("currency", (Object)this.currency).add("metadata", this.metadata).toString();
    }

    public static ImmutableCharge copyOf(Charge instance) {
        if (instance instanceof ImmutableCharge) {
            return (ImmutableCharge)instance;
        }
        return ImmutableCharge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EMAIL = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_AMOUNT = 4L;
        private static final long INIT_BIT_CURRENCY = 8L;
        private long initBits = 15L;
        @Nullable
        private String capture;
        @Nullable
        private Card card;
        @Nullable
        private String cardToken;
        @Nullable
        private String customerToken;
        @Nullable
        private String email;
        @Nullable
        private String description;
        @Nullable
        private Integer amount;
        @Nullable
        private String ipAddress;
        @Nullable
        private String currency;
        private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(ChargeBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Charge instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChargeBase instance;
            if (object instanceof ChargeBase) {
                instance = (ChargeBase)object;
                String ipAddressValue = instance.ipAddress();
                if (ipAddressValue != null) {
                    this.ipAddress(ipAddressValue);
                }
                this.description(instance.description());
                this.amount(instance.amount());
                this.putAllMetadata(instance.metadata());
                this.currency(instance.currency());
                this.email(instance.email());
            }
            if (object instanceof Charge) {
                String cardTokenValue;
                Card cardValue;
                String customerTokenValue;
                instance = (Charge)object;
                String captureValue = instance.capture();
                if (captureValue != null) {
                    this.capture(captureValue);
                }
                if ((customerTokenValue = instance.customerToken()) != null) {
                    this.customerToken(customerTokenValue);
                }
                if ((cardValue = instance.card()) != null) {
                    this.card(cardValue);
                }
                if ((cardTokenValue = instance.cardToken()) != null) {
                    this.cardToken(cardTokenValue);
                }
            }
        }

        public final Builder capture(@Nullable String capture) {
            this.capture = capture;
            return this;
        }

        public final Builder card(@Nullable Card card) {
            this.card = card;
            return this;
        }

        public final Builder cardToken(@Nullable String cardToken) {
            this.cardToken = cardToken;
            return this;
        }

        public final Builder customerToken(@Nullable String customerToken) {
            this.customerToken = customerToken;
            return this;
        }

        public final Builder email(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder ipAddress(@Nullable String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder putMetadata(String key, String value) {
            this.metadata.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            this.metadata.put(entry);
            return this;
        }

        public final Builder metadata(Map<String, ? extends String> metadata) {
            this.metadata = ImmutableMap.builder();
            return this.putAllMetadata(metadata);
        }

        public final Builder putAllMetadata(Map<String, ? extends String> metadata) {
            this.metadata.putAll(metadata);
            return this;
        }

        public ImmutableCharge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCharge(this.capture, this.card, this.cardToken, this.customerToken, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("email");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("currency");
            }
            return "Cannot build Charge, some of required attributes are not set " + attributes;
        }
    }
}

