/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.ChargeResponse;
import org.wisepersist.pinpayments.pojo.ChargeResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableChargeResponse
implements ChargeResponse {
    @Nullable
    private final ChargeResult response;
    @Nullable
    private final ErrorResponse errorResponse;

    private ImmutableChargeResponse(@Nullable ChargeResult response, @Nullable ErrorResponse errorResponse) {
        this.response = response;
        this.errorResponse = errorResponse;
    }

    @Override
    @Nullable
    public ChargeResult response() {
        return this.response;
    }

    @Override
    @Nullable
    public ErrorResponse errorResponse() {
        return this.errorResponse;
    }

    public final ImmutableChargeResponse withResponse(@Nullable ChargeResult value) {
        if (this.response == value) {
            return this;
        }
        return new ImmutableChargeResponse(value, this.errorResponse);
    }

    public final ImmutableChargeResponse withErrorResponse(@Nullable ErrorResponse value) {
        if (this.errorResponse == value) {
            return this;
        }
        return new ImmutableChargeResponse(this.response, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChargeResponse && this.equalTo((ImmutableChargeResponse)another);
    }

    private boolean equalTo(ImmutableChargeResponse another) {
        return Objects.equal((Object)this.response, (Object)another.response) && Objects.equal((Object)this.errorResponse, (Object)another.errorResponse);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.response});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorResponse});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ChargeResponse").omitNullValues().add("response", (Object)this.response).add("errorResponse", (Object)this.errorResponse).toString();
    }

    public static ImmutableChargeResponse copyOf(ChargeResponse instance) {
        if (instance instanceof ImmutableChargeResponse) {
            return (ImmutableChargeResponse)instance;
        }
        return ImmutableChargeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private ChargeResult response;
        @Nullable
        private ErrorResponse errorResponse;

        private Builder() {
        }

        public final Builder from(ChargeResponse instance) {
            ErrorResponse errorResponseValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            ChargeResult responseValue = instance.response();
            if (responseValue != null) {
                this.response(responseValue);
            }
            if ((errorResponseValue = instance.errorResponse()) != null) {
                this.errorResponse(errorResponseValue);
            }
            return this;
        }

        public final Builder response(@Nullable ChargeResult response) {
            this.response = response;
            return this;
        }

        public final Builder errorResponse(@Nullable ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        public ImmutableChargeResponse build() {
            return new ImmutableChargeResponse(this.response, this.errorResponse);
        }
    }
}

