/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CustomerResponse;
import org.wisepersist.pinpayments.pojo.CustomerResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCustomerResponse
implements CustomerResponse {
    @Nullable
    private final CustomerResult response;
    @Nullable
    private final ErrorResponse errorResponse;

    private ImmutableCustomerResponse(@Nullable CustomerResult response, @Nullable ErrorResponse errorResponse) {
        this.response = response;
        this.errorResponse = errorResponse;
    }

    @Override
    @Nullable
    public CustomerResult response() {
        return this.response;
    }

    @Override
    @Nullable
    public ErrorResponse errorResponse() {
        return this.errorResponse;
    }

    public final ImmutableCustomerResponse withResponse(@Nullable CustomerResult value) {
        if (this.response == value) {
            return this;
        }
        return new ImmutableCustomerResponse(value, this.errorResponse);
    }

    public final ImmutableCustomerResponse withErrorResponse(@Nullable ErrorResponse value) {
        if (this.errorResponse == value) {
            return this;
        }
        return new ImmutableCustomerResponse(this.response, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomerResponse && this.equalTo((ImmutableCustomerResponse)another);
    }

    private boolean equalTo(ImmutableCustomerResponse another) {
        return Objects.equal((Object)this.response, (Object)another.response) && Objects.equal((Object)this.errorResponse, (Object)another.errorResponse);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.response});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorResponse});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomerResponse").omitNullValues().add("response", (Object)this.response).add("errorResponse", (Object)this.errorResponse).toString();
    }

    public static ImmutableCustomerResponse copyOf(CustomerResponse instance) {
        if (instance instanceof ImmutableCustomerResponse) {
            return (ImmutableCustomerResponse)instance;
        }
        return ImmutableCustomerResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private CustomerResult response;
        @Nullable
        private ErrorResponse errorResponse;

        private Builder() {
        }

        public final Builder from(CustomerResponse instance) {
            ErrorResponse errorResponseValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            CustomerResult responseValue = instance.response();
            if (responseValue != null) {
                this.response(responseValue);
            }
            if ((errorResponseValue = instance.errorResponse()) != null) {
                this.errorResponse(errorResponseValue);
            }
            return this;
        }

        public final Builder response(@Nullable CustomerResult response) {
            this.response = response;
            return this;
        }

        public final Builder errorResponse(@Nullable ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        public ImmutableCustomerResponse build() {
            return new ImmutableCustomerResponse(this.response, this.errorResponse);
        }
    }
}

