/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.EventResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableEventResult
implements EventResult {
    private final String token;
    private final String type;
    private final HashMap<String, Object> data;
    private final String createdAt;

    private ImmutableEventResult(String token, String type, HashMap<String, Object> data, String createdAt) {
        this.token = token;
        this.type = type;
        this.data = data;
        this.createdAt = createdAt;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public HashMap<String, Object> data() {
        return this.data;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    public final ImmutableEventResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableEventResult(newValue, this.type, this.data, this.createdAt);
    }

    public final ImmutableEventResult withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        return new ImmutableEventResult(this.token, newValue, this.data, this.createdAt);
    }

    public final ImmutableEventResult withData(HashMap<String, Object> value) {
        if (this.data == value) {
            return this;
        }
        HashMap newValue = (HashMap)Preconditions.checkNotNull(value, (Object)"data");
        return new ImmutableEventResult(this.token, this.type, newValue, this.createdAt);
    }

    public final ImmutableEventResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableEventResult(this.token, this.type, this.data, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventResult && this.equalTo((ImmutableEventResult)another);
    }

    private boolean equalTo(ImmutableEventResult another) {
        return this.token.equals(another.token) && this.type.equals(another.type) && this.data.equals(another.data) && this.createdAt.equals(another.createdAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EventResult").omitNullValues().add("token", (Object)this.token).add("type", (Object)this.type).add("data", this.data).add("createdAt", (Object)this.createdAt).toString();
    }

    public static ImmutableEventResult copyOf(EventResult instance) {
        if (instance instanceof ImmutableEventResult) {
            return (ImmutableEventResult)instance;
        }
        return ImmutableEventResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_DATA = 4L;
        private static final long INIT_BIT_CREATED_AT = 8L;
        private long initBits = 15L;
        @Nullable
        private String token;
        @Nullable
        private String type;
        @Nullable
        private HashMap<String, Object> data;
        @Nullable
        private String createdAt;

        private Builder() {
        }

        public final Builder from(EventResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.token(instance.token());
            this.type(instance.type());
            this.data(instance.data());
            this.createdAt(instance.createdAt());
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder data(HashMap<String, Object> data) {
            this.data = (HashMap)Preconditions.checkNotNull(data, (Object)"data");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableEventResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEventResult(this.token, this.type, this.data, this.createdAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("data");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createdAt");
            }
            return "Cannot build EventResult, some of required attributes are not set " + attributes;
        }
    }
}

