/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Pagination;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutablePagination
implements Pagination {
    private final int current;
    private final int perPage;
    private final int count;

    private ImmutablePagination(int current, int perPage, int count) {
        this.current = current;
        this.perPage = perPage;
        this.count = count;
    }

    @Override
    public int current() {
        return this.current;
    }

    @Override
    public int perPage() {
        return this.perPage;
    }

    @Override
    public int count() {
        return this.count;
    }

    public final ImmutablePagination withCurrent(int value) {
        if (this.current == value) {
            return this;
        }
        return new ImmutablePagination(value, this.perPage, this.count);
    }

    public final ImmutablePagination withPerPage(int value) {
        if (this.perPage == value) {
            return this;
        }
        return new ImmutablePagination(this.current, value, this.count);
    }

    public final ImmutablePagination withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutablePagination(this.current, this.perPage, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePagination && this.equalTo((ImmutablePagination)another);
    }

    private boolean equalTo(ImmutablePagination another) {
        return this.current == another.current && this.perPage == another.perPage && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.current;
        h += (h << 5) + this.perPage;
        h += (h << 5) + this.count;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Pagination").omitNullValues().add("current", this.current).add("perPage", this.perPage).add("count", this.count).toString();
    }

    public static ImmutablePagination copyOf(Pagination instance) {
        if (instance instanceof ImmutablePagination) {
            return (ImmutablePagination)instance;
        }
        return ImmutablePagination.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CURRENT = 1L;
        private static final long INIT_BIT_PER_PAGE = 2L;
        private static final long INIT_BIT_COUNT = 4L;
        private long initBits = 7L;
        private int current;
        private int perPage;
        private int count;

        private Builder() {
        }

        public final Builder from(Pagination instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.current(instance.current());
            this.perPage(instance.perPage());
            this.count(instance.count());
            return this;
        }

        public final Builder current(int current) {
            this.current = current;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder perPage(int perPage) {
            this.perPage = perPage;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePagination build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePagination(this.current, this.perPage, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("current");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("perPage");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build Pagination, some of required attributes are not set " + attributes;
        }
    }
}

